/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4076;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

/**
 * Created by Mark on 13/03/2016.
 */
public class WorldUtils {

	public static void updateBlock(class_1937 world, class_2338 pos) {
		class_2680 state = world.method_8320(pos);
		world.method_8413(pos, state, state, 3);
	}

	/**
	 * Checks if chunk is loaded using proper chunk manager
	 *
	 * @param world {@link class_1937} World object
	 * @param pos   {@link class_2338} X and Z coordinates to check
	 * @return {@code boolean} True if chunk is loaded
	 */
	public static boolean isChunkLoaded(class_1937 world, class_2338 pos){
		return world.method_8398().method_12123(class_4076.method_18675(pos.method_10263()), class_4076.method_18675(pos.method_10260()));
	}


	public static void dropItem(class_1799 itemStack, class_1937 world, class_2338 pos) {
		class_5819 rand = class_5819.method_43047();

		float dX = rand.method_43057() * 0.8F + 0.1F;
		float dY = rand.method_43057() * 0.8F + 0.1F;
		float dZ = rand.method_43057() * 0.8F + 0.1F;

		class_1542 entityItem = new class_1542(world, pos.method_10263() + dX, pos.method_10264() + dY, pos.method_10260() + dZ,
				itemStack.method_7972());

		float factor = 0.05F;
		entityItem.method_18799(new class_243(rand.method_43059() * factor, rand.method_43059() * factor + 0.2F, rand.method_43059() * factor));
		if (!world.method_8608()) {
			world.method_8649(entityItem);
		}
	}

	public static void dropItem(class_1792 item, class_1937 world, class_2338 pos) {
		dropItem(new class_1799(item), world, pos);
	}

	public static void dropItems(List<class_1799> itemStackList, class_1937 world, class_2338 pos) {
		for (final class_1799 itemStack : itemStackList) {
			WorldUtils.dropItem(itemStack, world, pos);
			itemStack.method_7939(0);
		}
	}

	public static class_7871<class_2248> getBlockRegistryWrapper(@Nullable class_1937 world) {
		return world != null ? world.method_45448(class_7924.field_41254) : class_7923.field_41175;
	}
}
