/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2022 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.class_1935;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;

public final class TradeUtils {

	public enum Level {
		NOVICE, APPRENTICE, JOURNEYMAN, EXPERT, MASTER;

		public static final int SIZE = MASTER.ordinal() + 1;

		/**
		 * The number value of the job level as used internally.
		 * @return the level of the job as an int
		 */
		public int asInt() {
			return ordinal() + 1; // internally job levels start with 1, but ordinal() starts with 0
		}
	}

	private TradeUtils() {/* No instantiation. */}

	public static class_3853.class_1652 createSell(class_1935 item, int price, int count, int maxUses, int experience) {
		return new class_3853.class_4165(item.method_8389(), price, count, maxUses, experience);
	}

	public static class_3853.class_1652 createBuy(class_1935 item, int price, int count, int maxUses, int experience) {
		return new class_3853.class_4161(item, count, maxUses, experience, price);
	}

	public static void registerTradesForLevel(class_5321<class_3852> profession, Level level, boolean replace, class_3853.class_1652... newLevelTrades) {
		ExceptionUtils.requireNonNull(profession, "profession");
		ExceptionUtils.requireNonNull(level, "level");
		ExceptionUtils.requireNonNull(newLevelTrades, "newLevelTrades");
		ExceptionUtils.requireNonNullEntries(newLevelTrades, "newLevelTrades");

		Int2ObjectMap<class_3853.class_1652[]> allTrades = class_3853.field_17067.getOrDefault(profession, new Int2ObjectArrayMap<>(Level.SIZE));
		class_3853.class_1652[] oldLevelTrades = allTrades.getOrDefault(level.asInt(), new class_3853.class_1652[0]);
		class_3853.class_1652[] allLevelTrades;

		if (replace)
			allLevelTrades = newLevelTrades;
		else {
			allLevelTrades = new class_3853.class_1652[oldLevelTrades.length+newLevelTrades.length];
			System.arraycopy(oldLevelTrades,0,allLevelTrades,0,oldLevelTrades.length);
			System.arraycopy(newLevelTrades,0,allLevelTrades,oldLevelTrades.length,newLevelTrades.length);
		}

		allTrades.put(level.asInt(), allLevelTrades);
		class_3853.field_17067.put(profession, allTrades);
	}

}
