/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.NotNull;
import reborncore.api.items.InventoryBase;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;


public class RebornInventory<T extends MachineBaseBlockEntity> extends InventoryBase {

	private final String name;
	private final int stackLimit;
	private final T blockEntity;
	private boolean hasChanged = false;
	private final IInventoryAccess<T> inventoryAccess;

	public RebornInventory(int size, String invName, int invStackLimit, T blockEntity, IInventoryAccess<T> access) {
		super(size);
		name = invName;
		stackLimit = (invStackLimit == 64 ? class_1802.field_8162.method_7882() : invStackLimit); // Blame asie for this
		this.blockEntity = blockEntity;
		this.inventoryAccess = access;
	}

	// If you are using this with a machine, don't forget to set .withConfiguredAccess()
	public RebornInventory(int size, String invName, int invStackLimit, T blockEntity) {
		this(size, invName, invStackLimit, blockEntity, (slotID, stack, facing, direction, be) -> {
			if (facing == null) {
				return true;
			}
			return switch (direction) {
				case INSERT -> SlotConfiguration.canInsertItem(slotID, stack, facing, be);
				case EXTRACT -> SlotConfiguration.canExtractItem(slotID, stack, facing, be);
			};
		});
	}

	public String getName() {
		return name;
	}

	@Override
	public void method_5447(int slot, @NotNull class_1799 stack) {
		super.method_5447(slot, stack);
		setHashChanged();
	}

	@Override
	public class_1799 method_5434(int i, int i1) {
		class_1799 stack = super.method_5434(i, i1);

		if (!stack.method_7960()) {
			setHashChanged();
		}

		return stack;
	}

	@Override
	public int method_5444() {
		return stackLimit;
	}

	public class_1799 shrinkSlot(int slot, int count) {
		class_1799 stack = method_5438(slot);
		stack.method_7934(count);
		setHashChanged();
		return stack;
	}

	public void read(class_11368 view) {
		read(view, "Items");
	}

	public void read(class_11368 view, String tag) {
		view.method_71420(tag).ifPresent(data -> {
			readData(data);
			hasChanged = true;
		});
	}

	public void write(class_11372 view) {
		write(view, "Items");
	}

	public void write(class_11372 view, String tag) {
		writeData(view.method_71461(tag));
	}


	public int getContents() {
		int count = 0;
		for (class_1799 stack : getStacks()) {
			if (stack.method_7960()) {
				continue;
			}
			count += stack.method_7947();
		}
		return count;
	}

	public T getBlockEntity() {
		return blockEntity;
	}

	public boolean hasChanged() {
		return hasChanged;
	}

	public void setHashChanged() {
		this.hasChanged = true;
		this.method_5431();
	}

	public void setHashChanged(boolean changed) {
		this.hasChanged = changed;
	}

	public void resetHasChanged() {
		this.hasChanged = false;
	}

	public int getStackLimit() {
		return stackLimit;
	}

	@Override
	public void method_5431() {
		super.method_5431();
		blockEntity.method_5431();
	}

}
