/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import net.minecraft.class_2350;
import reborncore.common.blockentity.MachineBaseBlockEntity;

public enum MachineFacing {
	FRONT,
	BACK,
	UP,
	DOWN,
	LEFT,
	RIGHT;

	public class_2350 getFacing(MachineBaseBlockEntity machineBase) {
		if (this == FRONT) {
			return machineBase.getFacing();
		}
		if (this == BACK) {
			return machineBase.getFacing().method_10153();
		}
		if (this == RIGHT) {
			// North -> West
			int i = machineBase.getFacing().method_10153().method_10161() + 1;
			if (i > 3) {
				i = 0;
			}
			if (i < 0) {
				i = 3;
			}
			return class_2350.method_10139(i);
		}
		if (this == LEFT) {
			// North -> East
			int i = machineBase.getFacing().method_10153().method_10161() - 1;
			if (i > 3) {
				i = 0;
			}
			if (i < 0) {
				i = 3;
			}
			return class_2350.method_10139(i);
		}
		if (this == UP) {
			return class_2350.field_11036;
		}
		if (this == DOWN) {
			return class_2350.field_11033;
		}

		return class_2350.field_11043;
	}

}
