/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import net.minecraft.class_1799;
import net.minecraft.class_9288;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import reborncore.api.items.InventoryBase;

public class InventoryItem extends InventoryBase implements class_9322 {

	// ItemStack of InventoryItem
	@NotNull
	class_1799 stack;
	private final class_9323 components = class_9323.field_49584;

	private InventoryItem(@NotNull class_1799 stack, int size) {
		super(size);
		Validate.notNull(stack, "Stack is empty");
		Validate.isTrue(!stack.method_7960());
		this.stack = stack;
	}

	public @NotNull class_1799 getContainerStack() {
		return stack;
	}

	/**
	 * Copy inventory stacks from ContainerComponent to inventory. Call this in screenhandler.
	 */
	public final void readComponents(){
		components.method_58695(class_9334.field_49622, class_9288.field_49334).method_57492(this.getStacks());
	}

	/**
	 *  Save {@link net.minecraft.class_1263} to ContainerComponent
	 *
	 **/
	@Override
	public void method_5431() {
		class_9323.class_9324 builder = class_9323.method_57827();
		builder.method_57840(class_9334.field_49622, class_9288.method_57493(this.getStacks()));
		this.getContainerStack().method_57365(builder.method_57838());
	}

	@Override
	public class_9323 method_57353() {
		return !this.method_5442() ? this.components : class_9323.field_49584;
	}
}
