/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.screen.builder;

import org.apache.commons.lang3.Range;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_243;
import net.minecraft.class_2586;

public class ScreenHandlerBuilder {

	private final String name;

	final List<class_1735> slots;
	final List<Range<Integer>> playerInventoryRanges, blockEntityInventoryRanges;

	final List<SyncedObject<?>> objectValues;

	final List<Consumer<class_1715>> craftEvents;

	public ScreenHandlerBuilder(final String name) {

		this.name = name;

		this.slots = new ArrayList<>();
		this.playerInventoryRanges = new ArrayList<>();
		this.blockEntityInventoryRanges = new ArrayList<>();

		this.objectValues = new ArrayList<>();

		this.craftEvents = new ArrayList<>();
	}

	public PlayerScreenHandlerBuilder player(final class_1661 player) {
		return new PlayerScreenHandlerBuilder(this, player);
	}

	public BlockEntityScreenHandlerBuilder blockEntity(final class_2586 blockEntity) {
		return new BlockEntityScreenHandlerBuilder(this, blockEntity);
	}

	void addPlayerInventoryRange(final Range<Integer> range) {
		this.playerInventoryRanges.add(range);
	}

	void addBlockEntityInventoryRange(final Range<Integer> range) {
		this.blockEntityInventoryRanges.add(range);
	}

	private Predicate<class_1657> isUsable(MachineBaseBlockEntity blockEntity) {
		return playerEntity -> blockEntity.method_10997().method_8321(blockEntity.method_11016()) == blockEntity
				&& playerEntity.method_73189().method_1022(class_243.method_24954(blockEntity.method_11016())) < 16;
	}

	public BuiltScreenHandler create(final MachineBaseBlockEntity blockEntity, int syncID) {
		final BuiltScreenHandler built = new BuiltScreenHandler(syncID, this.name, isUsable(blockEntity),
				this.playerInventoryRanges,
				this.blockEntityInventoryRanges, blockEntity);
		if (!this.objectValues.isEmpty())
			built.addObjectSync(objectValues);
		if (!this.craftEvents.isEmpty()) {
			built.addCraftEvents(this.craftEvents);
		}

		this.slots.forEach(built::method_7621);

		this.slots.clear();
		return built;
	}
}
