/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2022 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.recipes;

import java.util.Objects;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2447;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;

public class PaddedShapedRecipeJsonBuilder extends class_2447 {

	public PaddedShapedRecipeJsonBuilder(class_7871<class_1792> registryLookup, class_7800 category, class_1935 output, int outputCount) {
		super(registryLookup, category, output, outputCount);
	}

	public static PaddedShapedRecipeJsonBuilder method_10437(class_7871<class_1792> registryLookup, class_7800 category, class_1935 output) {
		return method_10436(registryLookup, category, output, 1);
	}

	public static PaddedShapedRecipeJsonBuilder method_10436(class_7871<class_1792> registryLookup, class_7800 category, class_1935 output, int outputCount) {
		return new PaddedShapedRecipeJsonBuilder(registryLookup, category, output, outputCount);
	}
	@Override
	public void method_17972(class_8790 exporter, class_5321<class_1860<?>> recipeKey) {
		class_8957 raw = toRaw(recipeKey);

		class_8779 advancementEntry = exporter.method_53818()
			.method_705("has_the_recipe", class_2119.method_27847(recipeKey))
			.method_703(class_170.class_171.method_753(recipeKey))
			.method_704(class_8782.class_8797.field_1257)
			.method_695(recipeKey.method_29177());

		PaddedShapedRecipe shapedRecipe = new PaddedShapedRecipe(
			Objects.requireNonNullElse(this.field_11381, ""),
			class_5797.method_55308(this.field_40645),
			raw,
			new class_1799(this.field_11380, this.field_11378),
			this.field_42956
		);

		exporter.method_53819(recipeKey, shapedRecipe, advancementEntry);
	}

	private class_8957 toRaw(class_5321<class_1860<?>> recipeKey) {
		if (this.field_46149.isEmpty()) {
			throw new IllegalStateException("No way of obtaining recipe " + recipeKey.method_29177());
		} else {
			return PaddedShapedRecipe.create(this.field_11376, this.field_11377);
		}
	}
}
