/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.recipes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class PaddedShapedRecipe extends class_1869 {
	public static final class_2960 ID = class_2960.method_60655("reborncore", "padded");
	public static final class_1865<PaddedShapedRecipe> PADDED = class_2378.method_10230(class_7923.field_41189, ID, new reborncore.common.recipes.PaddedShapedRecipe.Serializer());

	final class_8957 raw;
	final class_1799 result;

	public PaddedShapedRecipe(String group, class_7710 category, class_8957 raw, class_1799 result, boolean showNotification) {
		super(group, category, raw, result, showNotification);
		this.raw = raw;
		this.result = result;
	}

	public static class_8957 create(Map<Character, class_1856> key, List<String> pattern) {
		class_8957.class_8958 data = new class_8957.class_8958(key, pattern);
		return fromData(data).getOrThrow();
	}

	// Basically a copy of ShapedRecipe.fromData
	private static DataResult<class_8957> fromData(class_8957.class_8958 data) {
		String[] strings = data.comp_2086().toArray(String[]::new);
		int width = strings[0].length();
		int height = strings.length;

		class_2371<Optional<class_1856>> ingredients = class_2371.method_10213(width * height, Optional.empty());
		CharSet charSet = new CharArraySet(data.comp_2085().keySet());

		for(int i = 0; i < strings.length; ++i) {
			String string = strings[i];

			for(int l = 0; l < string.length(); ++l) {
				char c = string.charAt(l);
				try {
					Optional<class_1856> ingredient = c == ' ' ? Optional.empty() : Optional.of(data.comp_2085().get(c));
					charSet.remove(c);
					ingredients.set(l + width * i, ingredient);
				}
				catch (NullPointerException ex) {
					return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
				}
			}
		}

		if (!charSet.isEmpty()) {
			return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + charSet);
		}

		return DataResult.success(new class_8957(width, height, ingredients, Optional.of(data)));
	}

	@Override
	public class_1865<? extends PaddedShapedRecipe> method_8119() {
		return PADDED;
	}

	public class_8957 getRaw() {
		return raw;
	}

	public class_1799 getResult() {
		return result;
	}

	private static class Serializer implements class_1865<PaddedShapedRecipe> {

		public static final MapCodec<PaddedShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(
			instance -> instance.group(Codec.STRING.optionalFieldOf("group", "").forGetter(PaddedShapedRecipe::method_8112),
					class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(PaddedShapedRecipe::method_45441),
					class_8957.field_47321.forGetter(PaddedShapedRecipe::getRaw),
					class_1799.field_51397.fieldOf("result").forGetter(PaddedShapedRecipe::getResult),
					Codec.BOOL.optionalFieldOf("show_notification", true).forGetter(PaddedShapedRecipe::method_49188))
				.apply(instance, PaddedShapedRecipe::new));

		public static final class_9139<class_9129, PaddedShapedRecipe> PACKET_CODEC = class_9139.method_56437(PaddedShapedRecipe.Serializer::write, PaddedShapedRecipe.Serializer::read);

		@Override
		public MapCodec<PaddedShapedRecipe> method_53736() {
			return CODEC;
		}

		@Override
		public class_9139<class_9129, PaddedShapedRecipe> method_56104() {
			return PACKET_CODEC;
		}

		private static PaddedShapedRecipe read(class_9129 buf) {
			String string = buf.method_19772();
			class_7710 craftingRecipeCategory = buf.method_10818(class_7710.class);
			class_8957 rawShapedRecipe = class_8957.field_48359.decode(buf);
			class_1799 itemStack = class_1799.field_48349.decode(buf);
			boolean showNotification = buf.readBoolean();
			return new PaddedShapedRecipe(string, craftingRecipeCategory, rawShapedRecipe, itemStack, showNotification);
		}

		private static void write(class_9129 buf, PaddedShapedRecipe recipe) {
			buf.method_10814(recipe.method_8112());
			buf.method_10817(recipe.method_45441());
			class_8957.field_48359.encode(buf, recipe.raw);
			class_1799.field_48349.encode(buf, recipe.result);
			buf.method_52964(recipe.method_49188());
		}
	}
}
