/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2024 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.network;

import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public interface BlockPosPayload {
	class_2338 pos();

	default boolean isWithinDistance(class_1657 player, double distance) {
		return player.method_24515().method_19771(pos(), distance);
	}

	default boolean canUse(class_3222 player, Predicate<class_1703> screenHandlerPredicate) {
		class_1703 currentScreenHandler = player.field_7512;

		if (currentScreenHandler == null) {
			return false;
		}

		if (!screenHandlerPredicate.test(currentScreenHandler)) {
			return false;
		}

		return currentScreenHandler.method_7597(player);
	}

	default <T extends class_2586> T getBlockEntity(class_2591<T> type, class_1657 player) {
		if (!isWithinDistance(player, 64)) {
			throw new IllegalStateException("Player cannot use this block entity as its too far away");
		}

		class_2586 blockEntity = getBlockEntity(player);

		if (type != blockEntity.method_11017()) {
			throw new IllegalStateException("Block entity is not of the correct type. Expected: " + class_7923.field_41181.method_10221(type) + " but got: " + class_7923.field_41181.method_10221(blockEntity.method_11017()));
		}

		//noinspection unchecked
		return (T) blockEntity;
	}

	default <T extends class_2586> T getBlockEntity(Class<T> baseClass, class_1657 player) {
		if (!isWithinDistance(player, 64)) {
			throw new IllegalStateException("Player cannot use this block entity as its too far away");
		}

		class_2586 blockEntity = getBlockEntity(player);

		if (!baseClass.isInstance(blockEntity)) {
			throw new IllegalStateException("Block entity is not of the correct class");
		}

		//noinspection unchecked
		return (T) blockEntity;
	}

	default class_2586 getBlockEntity(class_1657 player) {
		if (!isWithinDistance(player, 64)) {
			throw new IllegalStateException("Player cannot use this block entity as its too far away");
		}

		class_2586 blockEntity = player.method_73183().method_8321(pos());

		if (blockEntity == null) {
			throw new IllegalStateException("Block entity is null");
		}

		return blockEntity;
	}
}
