/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

/**
 * An ingredient with a specific item stack count
 * @param count The count of the ingredient
 * @param ingredient The ingredient
 */
public record SizedIngredient(int count, class_1856 ingredient) implements Predicate<class_1799> {
	public static MapCodec<SizedIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
		Codec.INT.optionalFieldOf("count", 1).forGetter(SizedIngredient::count),
		class_1856.field_46095.fieldOf("ingredient").forGetter(SizedIngredient::ingredient)
	).apply(instance, SizedIngredient::new));
	public static class_9139<class_9129, SizedIngredient> PACKET_CODEC = class_9139.method_56435(
		class_9135.field_49675, SizedIngredient::count,
		class_1856.field_48355, SizedIngredient::ingredient,
		SizedIngredient::new
	);

	@Override
	public boolean test(class_1799 itemStack) {
		if (itemStack.method_7960()) {
			// Never match empty stacks.
			return false;
		}

		if (itemStack.method_7947() < count) {
			return false;
		}

		return ingredient.method_8093(itemStack);
	}

	public List<class_1799> getPreviewStacks() {
		CustomIngredient customIngredient = ingredient.getCustomIngredient();
		Stream<class_1799> stacks;
		if (customIngredient != null) {
			stacks = ((class_10302.class_10304) customIngredient.toDisplay()).comp_3272().stream()
				.map(display -> ((class_10302.class_10307) display).comp_3274());
		} else {
			stacks = ingredient.field_9019.method_40239().map(entry -> new class_1799(entry.comp_349()));
		}
		return stacks.peek(itemStack -> itemStack.method_7939(count)).toList();
	}
}
