/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_8782;
import net.minecraft.class_8786;

public class RecipeUtils {
	public static <T extends RebornRecipe> List<T> getRecipes(class_1937 world, class_3956<T> type) {
		return streamRecipeEntries(world, type).map(class_8786::comp_1933).toList();
	}

	public static <T extends RebornRecipe> List<class_8786<T>> getRecipeEntries(class_1937 world, class_3956<T> type) {
		return streamRecipeEntries(world, type).toList();
	}

	private static <T extends RebornRecipe> Stream<class_8786<T>> streamRecipeEntries(class_1937 world, class_3956<T> type) {
		if (!(world instanceof class_3218 serverWorld)) {
			throw new IllegalArgumentException("World must be a ServerWorld");
		}

		return serverWorld.method_64577().method_8126().stream()
			.filter(recipe -> recipe.comp_1933().method_17716() == type)
			.map(recipe -> (class_8786<T>) recipe);
	}

	/**
	 * Adds the following toast/recipe defaults to an advancement builder:
	 * <ul>
	 *     <li>parent as "recipes/root"</li>
	 *     <li>criterion "has_the_recipe" via OR</li>
	 *     <li>reward: the specified recipe</li>
	 * </ul>
	 * @param builder the advancement task builder to expand
	 * @param registryKey the key of the recipe
	 * @throws NullPointerException If any parameter refers to <code>null</code>.
	 */
	public static void addToastDefaults(@NotNull class_161.class_162 builder, @NotNull class_5321<class_1860<?>> registryKey) {
		Objects.requireNonNull(builder);
		Objects.requireNonNull(registryKey);
		builder
			.method_705("has_the_recipe", class_2119.method_27847(registryKey))
			.method_703(class_170.class_171.method_753(registryKey))
			.method_704(class_8782.class_8797.field_1257);
	}

}
