/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class RecipeManager {
	public static class_3956<RebornRecipe> newRecipeType(class_2960 name) {
		return newRecipeType(name, RebornRecipe.CODEC, RebornRecipe.PACKET_CODEC);
	}

	public static <R extends RebornRecipe> class_3956<R> newRecipeType(class_2960 name, Function<class_3956<R>, MapCodec<R>> codec, Function<class_3956<R>, class_9139<class_9129, R>> packetCodec) {
		class_3956<R> type = new class_3956<R>() {
			@Override
			public String toString() {
				return name.toString();
			}
		};
		class_2378.method_10230(class_7923.field_41188, name, type);

		record Serializer<R extends RebornRecipe>(MapCodec<R> codec, class_9139<class_9129, R> streamCodec) implements class_1865<R> {}
		Serializer<R> serializer = new Serializer<>(codec.apply(type), packetCodec.apply(type));
		class_2378.method_10230(class_7923.field_41189, name, serializer);

		return type;
	}

	public static List<class_3956<?>> getRecipeTypes(String namespace) {
		//noinspection unchecked
		return class_7923.field_41188.method_42021().stream()
			.filter(key -> key.method_29177().method_12836().startsWith(namespace))
			.map((Function<class_5321<class_3956<?>>, class_3956<?>>) key -> class_7923.field_41188.method_63535(key.method_29177()))
			.toList();
	}
}
