/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record RebornRecipeDisplay(class_10302 result, class_10302 craftingStation) implements class_10295 {
	public static final MapCodec<RebornRecipeDisplay> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(class_10302.field_54671.fieldOf("result").forGetter(RebornRecipeDisplay::comp_3258), class_10302.field_54671.fieldOf("crafting_station").forGetter(RebornRecipeDisplay::comp_3259)).apply(instance, RebornRecipeDisplay::new));
	public static final class_9139<class_9129, RebornRecipeDisplay> field_54662;
	public static final class_10295.class_10296<RebornRecipeDisplay> SERIALIZER;

	public RebornRecipeDisplay(class_10302 craftingStation) {
		// TODO unlockedItem
		this(new class_10302.class_10307(class_1799.field_8037), craftingStation);
	}

	@Override
	public class_10296<? extends class_10295> method_64726() {
		return SERIALIZER;
	}

	static {
		field_54662 = class_9139.method_56435(class_10302.field_54672, RebornRecipeDisplay::comp_3258, class_10302.field_54672, RebornRecipeDisplay::comp_3259, RebornRecipeDisplay::new);
		SERIALIZER = new class_10295.class_10296<>(CODEC, field_54662);
	}
}
