/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.ApiStatus;
import reborncore.RebornCore;
import reborncore.api.recipe.IRecipeCrafterProvider;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9887;

public interface RebornRecipe extends class_1860<RebornRecipeInput> {
	Function<class_3956<RebornRecipe>, MapCodec<RebornRecipe>> CODEC = type -> RecordCodecBuilder.mapCodec(instance -> instance.group(
		Codec.list(SizedIngredient.CODEC.codec()).fieldOf("ingredients").forGetter(RebornRecipe::ingredients),
		Codec.list(class_1799.field_24671).fieldOf("outputs").forGetter(RebornRecipe::outputs),
		class_5699.field_33442.fieldOf("power").forGetter(RebornRecipe::power),
		class_5699.field_33442.fieldOf("time").forGetter(RebornRecipe::time)
	).apply(instance, (ingredients, outputs, power, time) -> new Default(type, ingredients, outputs, power, time)));
	Function<class_3956<RebornRecipe>, class_9139<class_9129, RebornRecipe>> PACKET_CODEC = type -> class_9139.method_56905(
		SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), RebornRecipe::ingredients,
		class_1799.field_48349.method_56433(class_9135.method_56363()), RebornRecipe::outputs,
		class_9135.field_49675, RebornRecipe::power,
		class_9135.field_49675, RebornRecipe::time,
		(ingredients, outputs, power, time) -> new Default(type, ingredients, outputs, power, time)
	);

	@ApiStatus.Internal
	record Default(class_3956<? extends RebornRecipe> type, List<SizedIngredient> ingredients, List<class_1799> outputs, int power, int time) implements RebornRecipe {
	}

	class_3956<? extends RebornRecipe> type();
	List<SizedIngredient> ingredients();
	List<class_1799> outputs();
	int power();
	int time();

	@Override
	default List<class_10295> method_64664() {
		class_2960 typeId = class_7923.field_41188.method_10221(type());
		Optional<class_1792> catalyst = class_7923.field_41178.method_17966(typeId);

		if (catalyst.isPresent()) {
			class_1799 stack = new class_1799(catalyst.get());
			return List.of(new RebornRecipeDisplay(new class_10302.class_10307(stack)));
		}

		RebornCore.LOGGER.warn("Missing toast icon for {}!", typeId);
		return class_1860.super.method_64664();
	}

	@Override
	default class_1865<? extends RebornRecipe> method_8119() {
		return (class_1865<? extends RebornRecipe>) class_7923.field_41189.method_63535(class_7923.field_41188.method_10221(method_17716()));
	}

	@Override
	default class_3956<? extends RebornRecipe> method_17716() {
		return type();
	}

	/**
	 * @param blockEntity {@link class_2586} The blockEntity that is doing the crafting
	 * @return {@code boolean} If true, the recipe will craft, if false it will not
	 */
	default boolean canCraft(class_2586 blockEntity) {
		if (blockEntity instanceof IRecipeCrafterProvider) {
			return ((IRecipeCrafterProvider) blockEntity).canCraft(this);
		}
		return true;
	}

	/**
	 * @param blockEntity {@link class_2586} The blockEntity that is doing the crafting
	 * @return {@code boolean} Returns true if fluid was taken and should craft
	 */
	default boolean onCraft(class_2586 blockEntity) {
		return true;
	}

	@Override
	default class_9887 method_61671() {
		return class_9887.field_52597;
	}

	// Done as our recipes do not support these functions, hopefully nothing blindly calls them
	@Deprecated
	@Override
	default boolean matches(RebornRecipeInput inv, class_1937 worldIn) {
		throw new UnsupportedOperationException();
	}

	@Override
	default class_1799 assemble(RebornRecipeInput inventory, class_7225.class_7874 lookup) {
		throw new UnsupportedOperationException();
	}

	@Override
	default class_10355 method_64668() {
		return null;
	}

	// Done to try and stop the table from loading it
	@Override
	default boolean method_8118() {
		return true;
	}
}
