/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.blocks;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import reborncore.api.ToolManager;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidUtils;
import reborncore.common.util.ItemHandlerUtils;
import reborncore.common.util.Tank;
import reborncore.common.util.WrenchUtils;

public abstract class BlockMachineBase extends BaseBlockEntityProvider implements class_3954 {

	public static final class_2754<class_2350> FACING = class_2741.field_12481;
	public static final class_2746 ACTIVE = class_2746.method_11825("active");

	boolean hasCustomStates;

	public BlockMachineBase(class_2248.Properties builder) {
		this(builder, false);
	}

	public BlockMachineBase(class_2248.Properties builder, boolean hasCustomStates) {
		super(builder);
		this.hasCustomStates = hasCustomStates;
		if (!hasCustomStates) {
			this.method_9590(
					this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(ACTIVE, false));
		}
		BlockWrenchEventHandler.wrenchableBlocks.add(this);
	}

	public void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
		if (hasCustomStates) {
			return;
		}
		world.method_8501(pos, world.method_8320(pos).method_11657(FACING, facing));
	}

	public class_2350 getFacing(class_2680 state) {
		return state.method_11654(FACING);
	}

	public void setActive(Boolean active, class_1937 world, class_2338 pos) {
		if (hasCustomStates) {
			return;
		}
		class_2350 facing = world.method_8320(pos).method_11654(FACING);
		class_2680 state = world.method_8320(pos).method_11657(ACTIVE, active).method_11657(FACING, facing);
		world.method_8652(pos, state, 3);
	}

	public boolean isActive(class_2680 state) {
		return state.method_11654(ACTIVE);
	}

	public boolean isAdvanced() {
		return false;
	}

	public abstract IMachineGuiHandler getGui();

	// BaseBlockEntityProvider
	@Override
	public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		super.method_9567(worldIn, pos, state, placer, stack);
		setFacing(placer.method_5735().method_10153(), worldIn, pos);

		class_2586 blockEntity = worldIn.method_8321(pos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			((MachineBaseBlockEntity) blockEntity).onPlace(worldIn, pos, state, placer, stack);
		}
	}

	@Override
	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return null;
	}

	// Block
	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING, ACTIVE);
	}

	@Override
	protected void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
		ItemHandlerUtils.dropContainedItems(worldIn, pos);
		super.method_66388(state, worldIn, pos, isMoving);
	}

	@Override
	public class_2680 method_9576(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 playerEntity) {
		class_2586 blockEntity = world.method_8321(blockPos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			((MachineBaseBlockEntity) blockEntity).onBreak(world, playerEntity, blockPos, blockState);
		}
		return super.method_9576(world, blockPos, blockState, playerEntity);
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
		return class_1703.method_7618(method_17680(state, world, pos));
	}


	/**
	 *
	 * 	Right-click should open GUI for all non-wrench items
	 * 	Shift-Right-click should apply special action, like fill\drain bucket, install behavior, etc.
	 *
	 */
	@Override
	public class_1269 method_55766(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_3965 hitResult) {

		class_1799 stack = playerIn.method_5998(class_1268.field_5808);
		class_2586 blockEntity = worldIn.method_8321(pos);

		// We extended BlockTileBase. Thus, we should always have blockEntity entity. I hope.
		if (blockEntity == null) {
			return class_1269.field_5811;
		}

		if (blockEntity instanceof MachineBaseBlockEntity) {
			Tank tank = ((MachineBaseBlockEntity) blockEntity).getTank();
			if (tank != null && FluidUtils.interactWithFluidHandler(playerIn, tank)) {
				return class_1269.field_5812;
			}
		}

		if (!stack.method_7960()) {
			if (ToolManager.INSTANCE.canHandleTool(stack)) {
				if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
					return class_1269.field_5812;
				}
			} else if (stack.method_7909() instanceof IUpgrade && blockEntity instanceof IUpgradeable upgradeableEntity) {
				if (upgradeableEntity.canBeUpgraded()) {
					int inserted = (int) insertItemStacked(
							InventoryStorage.of(upgradeableEntity.getUpgradeInventory(), null),
							ItemVariant.of(stack),
							stack.method_7947()
					);
					if (inserted > 0) {
						stack.method_7934(inserted);
						return class_1269.field_5812;
					}
				}
			}
		}

		if (getGui() != null && !playerIn.method_5715()) {
			getGui().open(playerIn, pos, worldIn);
			return class_1269.field_5812;
		}

		return super.method_55766(state, worldIn, pos, playerIn, hitResult);
	}

	// TODO: use the fabric one when it will be PR'ed.
	public static long insertItemStacked(InventoryStorage inventory, ItemVariant variant, long maxAmount) {
		long inserted = 0;
		try (Transaction tx = Transaction.openOuter()) {
			outer: for (int loop = 0; loop < 2; ++loop) {
				for (SingleSlotStorage<ItemVariant> slot : inventory.getSlots()) {
					if (slot.getResource().equals(variant) || loop == 1) {
						inserted += slot.insert(variant, maxAmount - inserted, tx);

						if (inserted == maxAmount) {
							break outer;
						}
					}
				}
			}

			tx.commit();
		}
		return inserted;
	}

	@Override
	public class_2680 method_9598(class_2680 state, class_2470 rotation) {
		return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
	}

	// InventoryProvider
	@Override
	public class_1278 method_17680(class_2680 blockState, class_1936 world, class_2338 blockPos) {
		class_2586 blockEntity = world.method_8321(blockPos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			return (MachineBaseBlockEntity) blockEntity;
		}
		return null;
	}
}
