/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common;

import org.jetbrains.annotations.Nullable;

import static reborncore.RebornCore.LOGGER;

import java.util.Optional;
import net.minecraft.class_11362;
import net.minecraft.class_11580;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import net.minecraft.class_8942;
import net.minecraft.class_9334;

public abstract class BaseBlockEntityProvider extends BaseBlock implements class_2343 {

	protected BaseBlockEntityProvider(class_2251 builder) {
		super(builder);
	}

	public Optional<class_1799> getDropWithContents(class_1937 world, class_2338 pos, class_1799 stack) {
		class_2586 blockEntity = world.method_8321(pos);
		if (blockEntity == null) {
			return Optional.empty();
		}

		class_1799 newStack = stack.method_7972();
		newStack.method_57365(blockEntity.method_57590());
		try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "BaseBlockEntityProvider", LOGGER)) {
			class_11362 view = class_11362.method_71459(logging, world.method_30349());
			blockEntity.method_38243(view);
			class_2487 blockEntityData = view.method_71475();
			newStack.method_57379(class_9334.field_49611, class_11580.method_72535(blockEntity.method_11017(), blockEntityData));
		}
		return Optional.of(newStack);
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
		super.method_9567(world, pos, state, placer, itemStack);

		class_11580<class_2591<?>> nbtComponent = itemStack.method_58694(class_9334.field_49611);
		if (nbtComponent == null) {
			return;
		}
		nbtComponent.method_72534(world.method_8321(pos), world.method_30349());
	}

	public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
		return (world1, pos, state1, blockEntity) -> {
			if (blockEntity instanceof class_5558) {
				((class_5558) blockEntity).tick(world1, pos, state1, blockEntity);
			}
		};
	}

	private void stripLocationData(class_2487 compound) {
		compound.method_10551("x");
		compound.method_10551("y");
		compound.method_10551("z");
	}

	private void injectLocationData(class_2487 compound, class_2338 pos) {
		compound.method_10569("x", pos.method_10263());
		compound.method_10569("y", pos.method_10264());
		compound.method_10569("z", pos.method_10260());
	}

	public void getDrops(class_2680 state, class_2371<class_1799> drops, class_1937 world, class_2338 pos, int fortune){

	}
}
