/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.multiblock;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;

public class MultiblockRenderer<T extends MachineBaseBlockEntity> implements class_827<T, MultiblockRenderer.MultiblockRenderState> {
	private final class_776 blockRenderDispatcher;
	private final class_10442 itemModelResolver;

	public MultiblockRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.comp_4535();
		this.itemModelResolver = ctx.comp_4536();
	}

	@Override
	public @NotNull MultiblockRenderState method_74335() {
		return new MultiblockRenderState();
	}

	@Override
	public void extractRenderState(
		T blockEntity,
		MultiblockRenderState state,
		float f,
		class_243 vec3,
		@Nullable class_11683.class_11792 crumblingOverlay
	) {
		class_11954.method_74399(blockEntity, state, crumblingOverlay);
		if (blockEntity.renderMultiblock && !blockEntity.isShapeValid()) {
			List<HologramRenderState> states = new ArrayList<>();
			class_2350 direction = blockEntity.getFacing().method_10153();
			blockEntity.writeMultiblock(new HologramRenderer(blockRenderDispatcher, itemModelResolver, blockEntity.method_10997(), states).rotate(direction));
			if (states.isEmpty()) {
				return;
			}
			state.states = states;
		}
	}

	@Override
	public void submit(
		MultiblockRenderState state,
		class_4587 poseStack,
		class_11659 submitNodeCollector,
		class_12075 cameraRenderState
	) {
		if (state.states != null) {
			for (HologramRenderState hologram : state.states) {
				hologram.submit(poseStack, submitNodeCollector, 0.4F);
			}
		}
	}

	@Override
	public boolean method_3563() {
		return true;
	}

	public static class MultiblockRenderState extends class_11954 {
		List<HologramRenderState> states;
	}
}
