/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2022 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.multiblock;

import reborncore.common.blockentity.MultiblockWriter;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10889;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_811;

/**
 * Renders a hologram
 */
public record HologramRenderer(class_776 blockRenderManager, class_10442 itemModelResolver, class_1937 view, List<HologramRenderState> states) implements MultiblockWriter {
	@Override
	public MultiblockWriter add(int x, int y, int z, BiPredicate<class_1922, class_2338> predicate, class_2680 state) {
		if (state.method_26204() instanceof class_2404) {
			class_3610 fluidState = state.method_26227();
			class_10444 item = new class_10444();
			itemModelResolver.method_65598(item, new class_1799(fluidState.method_15772().method_15774()), class_811.field_4319, view, null, 0);
			states.add(new HologramRenderState.FluidItem(x, y, z, item));
		} else {
			class_1921 layer = class_4696.method_23683(state);
			List<class_10889> parts = blockRenderManager.method_3349(state).method_68512(class_5819.method_43047());
			states.add(new HologramRenderState.Block(blockRenderManager, view, x, y, z, layer, state, parts));
		}
		return this;
	}
}
