/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2025 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.multiblock;

import java.util.List;
import net.minecraft.class_10444;
import net.minecraft.class_10889;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_776;

public interface HologramRenderState {
	class_2338 OUT_OF_WORLD_POS = new class_2338(0, 260, 0); // Bad hack; disables lighting

	void submit(class_4587 poseStack, class_11659 submitNodeCollector);

	default void submit(class_4587 poseStack, class_11659 submitNodeCollector, float scale) {
		poseStack.method_22903();
		poseStack.method_46416(x(), y(), z());
		poseStack.method_22904(0.5, 0.5, 0.5);
		poseStack.method_22905(scale, scale, scale);
		submit(poseStack, submitNodeCollector);
		poseStack.method_22909();
	}

	int x();

	int y();

	int z();

	record FluidItem(int x, int y, int z, class_10444 state) implements HologramRenderState {
		@Override
		public void submit(class_4587 poseStack, class_11659 submitNodeCollector) {
			state.method_65604(poseStack, submitNodeCollector, class_765.field_32767, class_4608.field_21444, 0);
		}
	}

	record Block(
		class_776 blockRenderManager, class_1937 view, int x, int y, int z, class_1921 layer, class_2680 state, List<class_10889> parts
	) implements HologramRenderState, class_11659.class_11660 {
		@Override
		public void render(class_4587.class_4665 pose, class_4588 vertexConsumer) {
			class_4587 matrix = new class_4587();
			matrix.method_34425(pose.method_23761());
			blockRenderManager.method_3355(state, OUT_OF_WORLD_POS, view, matrix, vertexConsumer, false, parts);
		}

		@Override
		public void submit(class_4587 poseStack, class_11659 submitNodeCollector) {
			poseStack.method_22904(-0.5, -0.5, -0.5);
			submitNodeCollector.method_73483(poseStack, layer, this);
		}
	}
}
