/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2025 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui.element;

import com.mojang.blaze3d.textures.GpuTextureView;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.minecraft.class_10799;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import org.joml.Matrix3x2f;
import org.joml.Quaternionfc;

import java.util.ArrayList;
import java.util.List;

public class MachineFaceElementRenderer extends class_11239<MachineFaceState> {
	private static final class_2350[] DIRECTIONS = class_2350.values();
	private static final RenderHandler renderHandler = new RenderHandler();
	private static final RenderElementHandler elementHandler = new RenderElementHandler();
	public static final List<class_2960> BLACKLIST = new ArrayList<>();

	public MachineFaceElementRenderer(SpecialGuiElementRegistry.Context context) {
		super(context.vertexConsumers());
	}

	@Override
	public Class<MachineFaceState> method_70903() {
		return MachineFaceState.class;
	}

	@Override
	protected String method_70906() {
		return "machine face";
	}

	@Override
	protected void renderToTexture(MachineFaceState state, class_4587 matrices) {
		renderHandler.update(state, matrices, field_59933);
		renderHandler.render(2, 0, class_7833.field_40716.rotationDegrees(90F)); //left
		renderHandler.render(1, 0, class_7833.field_40713.rotationDegrees(90F)); //top
		renderHandler.render(); //center
		renderHandler.render(-1, 1, class_7833.field_40714.rotationDegrees(90F)); //bottom
		renderHandler.render(-2, 0, class_7833.field_40716.rotationDegrees(90F)); //right
		renderHandler.render(-2, 0, class_7833.field_40716.rotationDegrees(180F)); //back
		renderHandler.clear();
	}

	@Override
	protected void blitTexture(MachineFaceState element, class_11246 state) {
		elementHandler.update(element, state, field_60572);
		elementHandler.render(4, 23); //left
		elementHandler.render(23, 4); //top
		elementHandler.render(23, 23); //center
		elementHandler.render(23, 42); //bottom
		elementHandler.render(42, 23); //right
		elementHandler.render(42, 42); //back
		elementHandler.clear();
	}

	static class RenderHandler {
		private class_4588 vertexConsumer;
		private class_1087 model;
		private class_4587.class_4665 source;
		private int light;

		public void clear() {
			vertexConsumer = null;
			model = null;
			source = null;
			light = 0;
		}

		public void render(float x, float y, Quaternionfc quaternionfc) {
			class_4587.class_4665 entry = source.method_56822();
			entry.method_67796(x, y, 0);
			entry.method_67798(quaternionfc);
			render(entry);
		}

		public void render() {
			render(source);
		}

		private void render(class_4587.class_4665 entry) {
			for (class_10889 blockModelPart : model.method_68512(class_5819.method_43049(42L))) {
				for (class_2350 direction : DIRECTIONS) {
					renderQuads(entry, blockModelPart.method_68509(direction));
				}
				renderQuads(entry, blockModelPart.method_68509(null));
			}
		}

		private void renderQuads(class_4587.class_4665 entry, List<class_777> bakedQuads) {
			for (class_777 bakedQuad : bakedQuads) {
				if (BLACKLIST.contains(bakedQuad.comp_3724().method_45851().method_45816())) {
					continue;
				}
				vertexConsumer.method_22919(entry, bakedQuad, 1.0F, 1.0F, 1.0F, 1.0F, light, class_4608.field_21444);
			}
		}

		public void update(MachineFaceState state, class_4587 matrices, class_4597.class_4598 vertexConsumers) {
			vertexConsumer = vertexConsumers.method_73477(class_1921.method_23577());
			model = state.model();
			light = class_4608.method_23210(15F);
			source = matrices.method_23760();
			source.method_67800(-16F, -16F, 0);
		}
	}

	static class RenderElementHandler {
		private class_11246 state;
		private class_11231 texture;
		private Matrix3x2f pose;
		private int x1;
		private int y1;
		private int i;

		public void clear() {
			state = null;
			texture = null;
			pose = null;
			x1 = 0;
			y1 = 0;
			i = -1;
		}

		public void render(int x, int y) {
			i++;
			int left = x1 + x;
			int top = y1 + y;
			float u1 = i / 6F;
			float u2 = (i + 1) / 6F;
			state.method_71996(new class_11241(
				class_10799.field_59968,
				texture,
				pose,
				left,
				top,
				left + 16,
				top + 16,
				u1,
				u2,
				1.0F,
				0.0F,
				-1,
				null,
				null
			));
		}

		public void update(MachineFaceState element, class_11246 guiRenderState, GpuTextureView textureView) {
			state = guiRenderState;
			texture = class_11231.method_70900(textureView);
			pose = element.method_72127();
			x1 = element.comp_4122();
			y1 = element.comp_4123();
			i = -1;
		}
	}
}
