/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui.config.elements;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4730;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.client.gui.Theme;
import reborncore.client.gui.ThemeManager;

public class ElementBase {
	private final int x;
	private final int y;
	private class_4730 sprite;
	private final int textureWidth;
	private final int textureHeight;
	protected final Theme theme;

	public ElementBase(int x, int y, class_4730 sprite, int textureWidth, int textureHeight) {
		this.sprite = sprite;
		this.textureWidth = textureWidth;
		this.textureHeight = textureHeight;
		this.x = x;
		this.y = y;
		theme = ThemeManager.getTheme();
	}

	protected void setSprite(class_4730 sprite) {
		this.sprite = sprite;
	}

	public void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
		drawSprite(drawContext, gui, sprite, x, y, textureWidth, textureHeight);
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public int getWidth() {
		return textureWidth;
	}

	public int getHeight() {
		return textureHeight;
	}

	public boolean onClick(GuiBase<?> gui, double mouseX, double mouseY) {
		return false;
	}

	public boolean mouseReleased(double mouseX, double mouseY, int state) {
		return false;
	}

	public int adjustX(GuiBase<?> gui, int x) {
		return gui.getGuiLeft() + x;
	}

	public int adjustY(GuiBase<?> gui, int y) {
		return gui.getGuiTop() + y;
	}

	public boolean isMouseWithinRect(GuiBase<?> gui, double mouseX, double mouseY) {
		return isInRect(gui, getX(), getY(), getWidth(), getHeight(), mouseX, mouseY);
	}

	public static boolean isInRect(GuiBase<?> gui, int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
		return gui.isPointInRect(x + gui.getGuiLeft(), y + gui.getGuiTop(), xSize, ySize, mouseX, mouseY);
	}

	public void drawText(class_332 drawContext, GuiBase<?> gui, class_2561 text, int x, int y, int color) {
		x = adjustX(gui, x);
		y = adjustY(gui, y);
		drawContext.method_51439(gui.method_64506(), text, x, y, color, false);
	}

	public void drawSprite(class_332 drawContext, GuiBase<?> gui, class_4730 spriteIdentifier, int x, int y, int textureWidth, int textureHeight) {
		GuiSprites.drawSpriteStretched(drawContext, spriteIdentifier, x + gui.getGuiLeft(), y + gui.getGuiTop(), textureWidth, textureHeight);
	}
}
