/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui.config.elements;

import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiSprites;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.screen.slot.BaseSlot;

import java.util.Arrays;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class ConfigSlotElement extends ParentElement {
	private final SlotType type;
	private final class_1263 inventory;
	private final int id;
	private final int height;

	public ConfigSlotElement(class_1263 slotInventory,
							BaseSlot slot,
							SlotType type,
							int x,
							int y,
							GuiBase<?> gui,
							Runnable closeConfig) {
		super(x, y, type.getButtonSprite(), type.getTextureWidth(), type.getTextureHeight());
		this.type = type;
		this.inventory = slotInventory;
		this.id = slot.method_34266();

		SlotConfigPopupElement popupElement;

		boolean inputEnabled = slot.canWorldBlockInsert();
		boolean filterEnabled = gui.getMachine() instanceof SlotConfiguration.SlotFilter slotFilter
								&& Arrays.stream(slotFilter.getInputSlots()).anyMatch(value -> value == id);
		this.height = 107 + (inputEnabled ? 15 : 0) + (filterEnabled ? 15 : 0);

		elements.add(popupElement = new SlotConfigPopupElement(this.id, x - 22, y - 22, height, inputEnabled));
		elements.add(new ButtonElement(x + 37, y - 25, GuiSprites.EXIT_BUTTON, 13, 13, closeConfig));

		int checkboxY = y + 44;
		if (inputEnabled) {
			elements.add(new CheckBoxElement(class_2561.method_43471("reborncore.gui.slotconfig.autoinput"), x - 26, checkboxY += 15,
				checkBoxElement ->  gui.getMachine().getSlotConfiguration().getSlotDetails(id).autoInput(),
				() -> popupElement.updateCheckBox("input", gui)));
		}

		elements.add(new CheckBoxElement(class_2561.method_43471("reborncore.gui.slotconfig.autooutput"), x - 26, checkboxY += 15,
			checkBoxElement ->  gui.getMachine().getSlotConfiguration().getSlotDetails(id).autoOutput(),
			() -> popupElement.updateCheckBox("output", gui)));

		if (filterEnabled) {
			elements.add(new CheckBoxElement(class_2561.method_43471("reborncore.gui.slotconfig.filter_input"), x - 26, checkboxY + 15,
				checkBoxElement ->  gui.getMachine().getSlotConfiguration().getSlotDetails(id).filter(),
				() -> popupElement.updateCheckBox("filter", gui)));
		}
	}

	@Override
	public int getWidth() {
		return 85;
	}

	@Override
	public int getHeight() {
		return height;
	}

	@Override
	public void draw(class_332 drawContext, GuiBase<?> gui, int mouseX, int mouseY) {
		class_1799 stack = inventory.method_5438(id);
		int xPos = getX() + 1 + gui.getGuiLeft();
		int yPos = getY() + 1 + gui.getGuiTop();

		drawContext.method_51427(stack, xPos, yPos);

		if (isMouseWithinRect(gui, mouseX, mouseY)) {
			drawSprite(drawContext, gui, type.getButtonHoverOverlay(), getX(), getY(), type.getTextureWidth(), type.getTextureHeight());
		}
		super.draw(drawContext, gui, mouseX, mouseY);
	}


	public int getId() {
		return id;
	}
}
