/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.gui;

import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.config.GuiTab;
import reborncore.client.gui.widget.GuiButtonHologram;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.slot.PlayerInventorySlot;

import java.util.*;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3611;
import net.minecraft.class_465;
import net.minecraft.class_4730;
import net.minecraft.class_6379;

public class GuiBase<T extends class_1703> extends class_465<T> {
	public static FluidCellProvider fluidCellProvider = fluid -> class_1799.field_8037;
	public static class_1799 wrenchStack = class_1799.field_8037;

	public GuiBuilder builder = new GuiBuilder();
	public class_2586 be;
	@Nullable
	public BuiltScreenHandler builtScreenHandler;
	private final int xSize = 176;
	private final int ySize = 176;

	@Nullable
	private GuiTab selectedTab = null;
	private final List<GuiTab> tabs;
	protected final Theme theme;

	public boolean upgrades;

	public GuiBase(class_1657 player, class_2586 blockEntity, T screenHandler) {
		super(screenHandler, player.method_31548(), class_2561.method_43470(class_1074.method_4662(blockEntity.method_11010().method_26204().method_63499())));
		this.be = blockEntity;
		this.builtScreenHandler = (BuiltScreenHandler) screenHandler;
		tabs = GuiTab.TABS.stream()
			.map(factory -> factory.create(this))
			.filter(GuiTab::enabled)
			.toList();
		theme = ThemeManager.getTheme();
	}

	public int getScreenWidth() {
		return field_2792;
	}

	public void drawSlot(class_332 drawContext, int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawSlot(drawContext, x - 1, y - 1);
	}

	public void drawOutputSlotBar(class_332 drawContext, int x, int y, int count, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawOutputSlotBar(drawContext, x - 4, y - 4, count);
	}

	public void drawArmourSlots(class_332 drawContext, int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawSlot(drawContext, x - 1, y - 1);
		builder.drawSlot(drawContext, x - 1, y - 1 + 18);
		builder.drawSlot(drawContext, x - 1, y - 1 + 18 + 18);
		builder.drawSlot(drawContext, x - 1, y - 1 + 18 + 18 + 18);
	}

	public void drawOutputSlot(class_332 drawContext, int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += this.field_2776;
			y += this.field_2800;
		}
		builder.drawOutputSlot(drawContext, x - 5, y - 5);
	}

	@Override
	public void method_25426() {
		super.method_25426();
		for (GuiTab tab : tabs) {
			tab.open();
		}
	}

	@Override
	protected void method_2389(class_332 drawContext, float lastFrameDuration, int mouseX, int mouseY) {
		drawContext.method_25290(class_10799.field_56883, field_2801, field_2776, field_2800, 0, 0, this.field_2792, this.field_2779, 256, 256);
		boolean drawPlayerSlots = selectedTab == null && drawPlayerSlots();
		updateSlotDraw(drawPlayerSlots);
		builder.drawDefaultBackground(drawContext, field_2776, field_2800, xSize, ySize);
		if (drawPlayerSlots) {
			builder.drawPlayerSlots(drawContext, this, field_2776 + field_2792 / 2, field_2800 + 93, true);
		}
		if (tryAddUpgrades() && be instanceof IUpgradeable upgradeable) {
			if (upgradeable.canBeUpgraded()) {
				builder.drawUpgrades(drawContext, this, field_2776 - 24, field_2800 + 6);
				upgrades = true;
			}
		}
		int offset = upgrades ? 86 : 6;
		for (GuiTab slot : tabs) {
			if (slot.enabled()) {
				builder.drawSlotTab(drawContext, this, field_2776 - 24, field_2800 + offset, slot.stack());
				offset += 24;
			}
		}

		final GuiBase<T> gui = this;
		getTab().ifPresent(guiTab -> builder.drawSlotConfigTips(drawContext, gui, field_2776 + field_2792 / 2, field_2800 + 93, mouseX, mouseY, guiTab));

	}

	private void updateSlotDraw(boolean doDraw) {
		if (builtScreenHandler == null) {
			return;
		}
		for (class_1735 slot : builtScreenHandler.field_7761) {
			if (slot instanceof PlayerInventorySlot) {
				((PlayerInventorySlot) slot).doDraw = doDraw;
			}
		}
	}

	public boolean drawPlayerSlots() {
		return true;
	}

	public boolean tryAddUpgrades() {
		return true;
	}

	@Override
	protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
		drawTitle(drawContext);
	}

	@Override
	public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(drawContext, mouseX, mouseY, partialTicks);
		this.method_2380(drawContext, mouseX, mouseY);

		drawContext.method_51448().pushMatrix();
		drawContext.method_51448().translate(this.field_2776, this.field_2800);
		getTab().ifPresent(guiTab -> guiTab.draw(drawContext, mouseX, mouseY));
		drawContext.method_51448().popMatrix();
	}

	@Override
	protected void method_2380(class_332 drawContext, int mouseX, int mouseY) {
		if (method_2378(-25, 6, 24, 80, mouseX, mouseY) && upgrades
				&& this.field_2787 != null && !this.field_2787.method_7681()) {
			List<class_2561> list = new ArrayList<>();
			list.add(class_2561.method_43471("reborncore.gui.tooltip.upgrades"));
			drawContext.method_51434(class_310.method_1551().field_1772, list, mouseX, mouseY);
		}
		int offset = upgrades ? 82 : 0;
		for (GuiTab tab : tabs) {
			if (method_2378(-26, 6 + offset, 24, 23, mouseX, mouseY)) {
				drawContext.method_51434(class_310.method_1551().field_1772, Collections.singletonList(class_2561.method_43471(tab.name())), mouseX, mouseY);
			}
			offset += 24;
		}

		for (class_6379 selectable : field_33815) {
			if (selectable instanceof class_339 clickable) {
				if (clickable.method_49606()) {
					// TODO 1.19.3
					// clickable.renderTooltip(matrixStack, mouseX, mouseY);
					break;
				}
			}

		}
		super.method_2380(drawContext, mouseX, mouseY);
	}

	protected void drawTitle(class_332 drawContext) {
		drawCentredText(drawContext, class_2561.method_43471(be.method_11010().method_26204().method_63499()), 6, theme.titleColor().comp_1971(), Layer.FOREGROUND);
	}

	public void drawCentredText(class_332 drawContext, class_2561 text, int y, int colour, Layer layer) {
		drawText(drawContext, text, (field_2792 / 2 - method_64506().method_27525(text) / 2), y, colour, layer);
	}

	public void drawCentredText(class_332 drawContext, class_2561 text, int y, int colour, int modifier, Layer layer) {
		drawText(drawContext, text, (field_2792 / 2 - (method_64506().method_27525(text)) / 2) + modifier, y, colour, layer);
	}

	public void drawText(class_332 drawContext, class_2561 text, int x, int y, int colour, Layer layer) {
		int factorX = 0;
		int factorY = 0;
		if (layer == Layer.BACKGROUND) {
			factorX = this.field_2776;
			factorY = this.field_2800;
		}
		drawContext.method_51439(class_310.method_1551().field_1772, text, x + factorX, y + factorY, colour, false);
	}

	public GuiButtonHologram addHologramButton(int x, int y, int id, Layer layer) {
		GuiButtonHologram buttonHologram = new GuiButtonHologram(x + this.field_2776, y + this.field_2800, var1 -> {
		});
		method_25429(buttonHologram);
		return buttonHologram;
	}

	@Override
	public boolean method_25402(class_11909 mouse, boolean doubled) {
		if (getTab().map(guiTab -> guiTab.click(mouse.comp_4798(), mouse.comp_4799(), mouse.method_74245())).orElse(false)) {
			return true;
		}
		return super.method_25402(mouse, doubled);
	}

	@Override
	public boolean method_25406(class_11909 mouse) {
		getTab().ifPresent(guiTab -> guiTab.mouseReleased(mouse.comp_4798(), mouse.comp_4799(), mouse.method_74245()));
		int offset = 0;
		if (!upgrades) {
			offset = 80;
		}
		for (GuiTab tab : tabs) {
			if (method_2378(-26, 84 - offset, 30, 23, mouse.comp_4798(), mouse.comp_4799())) {
				if (selectedTab == tab) {
					closeSelectedTab();
				} else {
					setSelectedTab(tab);
				}
				break;
			}
			offset -= 24;
		}

		return super.method_25406(mouse);
	}

	@Override
	public boolean method_25404(class_11908 key) {
		if (getTab().map(guiTab -> guiTab.keyPress(key)).orElse(false)) {
			return true;
		}
		if (selectedTab != null && key.comp_4795() == GLFW.GLFW_KEY_ESCAPE) {
			closeSelectedTab();
			return true;
		}
		return super.method_25404(key);
	}

	@Override
	public void method_25419() {
		closeSelectedTab();
		super.method_25419();
	}

	public MachineBaseBlockEntity getMachine() {
		return (MachineBaseBlockEntity) be;
	}

	/**
	 * @param rectX      {@code int} Top left corner of region
	 * @param rectY      {@code int} Top left corner of region
	 * @param rectWidth  {@code int} Width of region
	 * @param rectHeight {@code int} Height of region
	 * @param pointX     {@code int} Mouse pointer
	 * @param pointY     {@code int} Mouse pointer
	 * @return {@code boolean} Returns true if mouse pointer is in region specified
	 */
	public boolean isPointInRect(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
		return super.method_2378(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
	}

	public enum Layer {
		BACKGROUND, FOREGROUND
	}

	public interface FluidCellProvider {
		class_1799 provide(class_3611 fluid);
	}

	public boolean isConfigEnabled() {
		return be instanceof MachineBaseBlockEntity && builtScreenHandler != null;
	}

	public int getGuiLeft() {
		return field_2776;
	}

	public int getGuiTop() {
		return field_2800;
	}

	public class_310 getMinecraft() {
		// Just to stop complaints from IDEA
		if (field_22787 == null) {
			throw new NullPointerException("Minecraft client is null.");
		}
		return this.field_22787;
	}

	public class_327 method_64506() {
		return this.field_22793;
	}

	public Optional<GuiTab> getTab() {
		if (!isConfigEnabled()) {
			return Optional.empty();
		}
		return Optional.ofNullable(selectedTab);
	}

	public boolean isTabOpen() {
		return selectedTab != null;
	}

	public boolean hideGuiElements() {
		return selectedTab != null && selectedTab.hideGuiElements();
	}

	private void setSelectedTab(GuiTab tab) {
		Objects.requireNonNull(tab);
		selectedTab = tab;
		selectedTab.open();
	}

	public void closeSelectedTab() {
		if (selectedTab != null) {
			selectedTab.close();
		}

		selectedTab = null;
	}

	public GuiTab getSelectedTab() {
		return selectedTab;
	}

	@Override
	protected boolean method_2381(double mouseX, double mouseY, int left, int top) {
		// Upgrades are normally outside the bounds, so let's pretend we are within the bounds if there is a slot here.
		return method_64240(mouseX, mouseY) == null && super.method_2381(mouseX, mouseY, left, top);
	}

	public List<GuiTab> getTabs() {
		return tabs;
	}

	public static class_1058 getSprite(class_4730 spriteIdentifier) {
		return class_310.method_1551().method_72703().method_73025(spriteIdentifier.method_24144()).method_4608(spriteIdentifier.method_24147());
	}
}
