/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import reborncore.common.fluid.FluidSettings;
import reborncore.common.fluid.RebornFluid;
import reborncore.common.fluid.RebornFluidManager;
import reborncore.common.util.TemporaryLazy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RebornFluidRenderManager implements SimpleSynchronousResourceReloadListener {

	private static final Map<class_3611, TemporaryLazy<class_1058[]>> spriteMap = new HashMap<>();

	public static void setupClient() {
		RebornFluidRenderManager rebornFluidRenderManager = new RebornFluidRenderManager();
		ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(rebornFluidRenderManager);
		RebornFluidManager.getFluidStream().forEach(RebornFluidRenderManager::setupFluidRenderer);
	}

	private static void setupFluidRenderer(RebornFluid fluid) {
		// Done lazy as we want to ensure we get the sprite at the correct time,
		// but also don't want to be making these calls every time its required.
		TemporaryLazy<class_1058[]> sprites = new TemporaryLazy<>(() -> {
			FluidSettings fluidSettings = fluid.getFluidSettings();
			return new class_1058[]{RenderUtil.getSprite(fluidSettings.getStillTexture()), RenderUtil.getSprite(fluidSettings.getFlowingTexture())};
		});

		spriteMap.put(fluid, sprites);
		FluidRenderHandlerRegistry.INSTANCE.register(fluid, (extendedBlockView, blockPos, fluidState) -> sprites.get());
	}

	@Override
	public class_2960 getFabricId() {
		return class_2960.method_60655("reborncore", "fluid_render_manager");
	}

	@Override
	public void method_14491(class_3300 manager) {
		// Reset the cached fluid sprites
		spriteMap.forEach((key, value) -> value.reset());
	}

	@Override
	public Collection<class_2960> getFabricDependencies() {
		return Collections.singletonList(ResourceReloadListenerKeys.TEXTURES);
	}
}
