/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_10444;
import net.minecraft.class_11278;
import net.minecraft.class_11684;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9779;
import org.joml.Matrix4fStack;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Initially taken from https://github.com/JamiesWhiteShirt/developer-mode/tree/experimental-item-render
 * and then ported to 1.15
 * Thanks 2xsaiko for fixing the lighting + odd issues above
 */
public class ItemStackRenderer implements HudRenderCallback {
	private static class_11278 guiProjectionMatrix;
	private static final int SIZE = 512;

	@Override
	public void onHudRender(class_332 drawContext, class_9779 tickCounter) {
		if (!ItemStackRenderManager.RENDER_QUEUE.isEmpty()) {
			if (guiProjectionMatrix == null) {
				guiProjectionMatrix = new class_11278("gui", 1000.0F, 11000.0F, true);
			}
			class_1799 itemStack = ItemStackRenderManager.RENDER_QUEUE.remove();
			export(drawContext, itemStack, ItemStackRenderManager.RENDER_QUEUE.size());
		}
	}

	private void export(class_332 drawContext, class_1799 stack, int queue) {
		class_310 client = class_310.method_1551();
		class_276 framebuffer = client.method_1522();
		GpuTexture gpuTexture = framebuffer.method_30277();
		if (gpuTexture == null) {
			return;
		}
		// clear background
		RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(gpuTexture, 0, framebuffer.method_30278(), 1);

		// draw info
		class_1041 window = client.method_22683();
		float scaleFactor = window.method_4495();
		final int drawSize = Math.min(framebuffer.field_1481, SIZE);
		int left = (int) (drawSize / scaleFactor) + 5;
		class_2960 identifier = class_7923.field_41178.method_10221(stack.method_7909());
		drawContext.method_51433(client.field_1772, "Rendering " + identifier, left, 5, -1, false);
		drawContext.method_51433(client.field_1772, queue + " items left", left, 15, -1, false);

		// draw item stack
		RenderSystem.backupProjectionMatrix();
		RenderSystem.setProjectionMatrix(
			guiProjectionMatrix.method_71092(window.method_4489() / scaleFactor, window.method_4506() / scaleFactor),
			class_10366.field_54954
		);
		Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
		matrix4fStack.pushMatrix();
		matrix4fStack.translate(0, 0, -11000);
		class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
		class_4587 matrices = new class_4587();
		matrices.method_22903();
		float drawScale = drawSize / (16 * scaleFactor);
		matrices.method_22905(drawScale, drawScale, drawScale);
		class_10444 itemRenderState = new class_10444();
		client.method_65386().method_65598(itemRenderState, stack, class_811.field_4317, client.field_1687, client.field_1724, 0);
		matrices.method_46416(8, 8, 150);
		matrices.method_22905(16.0F, -16.0F, 16.0F);
		boolean bl = !itemRenderState.method_65608();
		class_757 gameRenderer = class_310.method_1551().field_1773;
		class_308 diffuseLighting = gameRenderer.method_71114();
		if (bl) {
			diffuseLighting.method_71034(class_308.class_11274.field_60026);
		} else {
			diffuseLighting.method_71034(class_308.class_11274.field_60027);
		}
		class_11684 renderDispatcher = gameRenderer.method_72911();
		itemRenderState.method_65604(matrices, renderDispatcher.method_73003(), class_765.field_32767, class_4608.field_21444, 0);
		renderDispatcher.method_73002();
		vertexConsumers.method_22993();
		matrix4fStack.popMatrix();
		RenderSystem.restoreProjectionMatrix();

		// export image
		int pixelSize = gpuTexture.getFormat().pixelSize();
		final GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(
			() -> "Export buffer",
			9,
			framebuffer.field_1482 * framebuffer.field_1481 * pixelSize
		);
		final CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
		commandEncoder.copyTextureToBuffer(
			gpuTexture,
			gpuBuffer,
			0,
			() -> {
				try (GpuBuffer.MappedView readView = commandEncoder.mapBuffer(gpuBuffer, true, false)) {
					ByteBuffer imageData = readView.data();
					class_1011 nativeImage = null;
					try {
						int scale = drawSize < SIZE ? 2 : 1;
						int imageSize = drawSize * scale;
						nativeImage = new class_1011(imageSize, imageSize, false);
						for (int rowIndex = 0, maxRowIndex = imageSize - 1, scaledRowIndex; rowIndex < drawSize; rowIndex++) {
							scaledRowIndex = rowIndex * scale;
							for (int colIndex = 0, scaledColIndex; colIndex < drawSize; colIndex++) {
								scaledColIndex = colIndex * scale;
								int color = imageData.getInt((colIndex + rowIndex * drawSize) * pixelSize);
								for (int x = 0; x < scale; x++) {
									for (int y = 0; y < scale; y++) {
										nativeImage.method_4305(scaledColIndex + x, maxRowIndex - scaledRowIndex - y, color);
									}
								}
							}
						}
						if (drawSize < SIZE) {
							class_1011 destroy = null;
							try {
								class_1011 resizedImage = new class_1011(SIZE, SIZE, false);
								destroy = resizedImage;
								nativeImage.method_4300(0, 0, imageSize, imageSize, resizedImage);
								destroy = nativeImage;
								nativeImage = resizedImage;
							} catch(Exception ignored) {}
							finally {
								if (destroy != null) {
									try {
										destroy.close();
									} catch(Exception ignored) {}
								}
							}
						}
						Path path = FabricLoader.getInstance().getGameDir().resolve("item_renderer")
							.resolve(identifier.method_12836()).resolve(identifier.method_12832() + ".png");
						Files.createDirectories(path.getParent());
						nativeImage.method_4314(path);
					} catch (Exception e) {
						e.printStackTrace();
					} finally {
						if (nativeImage != null) {
							try {
								nativeImage.close();
							} catch(Exception ignored) {}
						}
					}
				}
				gpuBuffer.close();
			},
			0,
			0,
			framebuffer.field_1481 - drawSize,
			drawSize,
			drawSize
		);
	}
}
