/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11352;
import net.minecraft.class_1703;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_8942;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reborncore.RebornCore;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.network.clientbound.ChunkSyncPayload;
import reborncore.common.network.clientbound.CustomDescriptionPayload;
import reborncore.common.network.clientbound.FluidConfigSyncPayload;
import reborncore.common.network.clientbound.QueueItemStacksPayload;
import reborncore.common.network.clientbound.ScreenHandlerUpdatePayload;
import reborncore.common.network.clientbound.SlotSyncPayload;
import reborncore.common.screen.BuiltScreenHandler;

public class ClientBoundPacketHandlers {
	private static final Logger LOGGER = LoggerFactory.getLogger(ClientBoundPacketHandlers.class);

	public static void init() {
		ClientPlayNetworking.registerGlobalReceiver(CustomDescriptionPayload.ID, (payload, context) -> {
			class_638 world = class_310.method_1551().field_1687;
			if (world.method_8477(payload.pos())) {
				class_2586 blockentity = world.method_8321(payload.pos());
				if (blockentity != null && payload.nbt() != null) {
					try (class_8942.class_11340 logging = new class_8942.class_11340(blockentity.method_71402(), LOGGER)) {
						blockentity.method_58690(class_11352.method_71417(logging, world.method_30349(), payload.nbt()));
					}
				}
			}
		});

		ClientPlayNetworking.registerGlobalReceiver(FluidConfigSyncPayload.ID, (payload, context) -> {
			FluidConfiguration fluidConfiguration = payload.fluidConfiguration();
			if (!class_310.method_1551().field_1687.method_8477(payload.pos())) {
				return;
			}
			MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity) class_310.method_1551().field_1687.method_8321(payload.pos());
			if (machineBase == null || machineBase.fluidConfiguration == null || fluidConfiguration == null) {
				RebornCore.LOGGER.error("Failed to sync fluid config data to " + payload.pos());
				return;
			}
			fluidConfiguration.getAllSides().forEach(fluidConfig -> machineBase.fluidConfiguration.updateFluidConfig(fluidConfig));
			machineBase.fluidConfiguration.setInput(fluidConfiguration.autoInput());
			machineBase.fluidConfiguration.setOutput(fluidConfiguration.autoOutput());;
		});

		ClientPlayNetworking.registerGlobalReceiver(SlotSyncPayload.ID, (payload, context) -> {
			SlotConfiguration slotConfig = payload.slotConfig();
			if (!class_310.method_1551().field_1687.method_8477(payload.pos())) {
				return;
			}
			MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity) class_310.method_1551().field_1687.method_8321(payload.pos());
			if (machineBase == null || machineBase.getSlotConfiguration() == null || slotConfig == null || slotConfig.getSlotDetails() == null) {
				RebornCore.LOGGER.error("Failed to sync slot data to " + payload.pos());
				return;
			}
			class_310.method_1551().execute(() -> slotConfig.getSlotDetails().forEach(slotConfigHolder -> machineBase.getSlotConfiguration().updateSlotDetails(slotConfigHolder)));
		});

		ClientPlayNetworking.registerGlobalReceiver(ScreenHandlerUpdatePayload.ID, (payload, context) -> {
			class_437 gui = class_310.method_1551().field_1755;
			if (gui instanceof class_465 handledScreen) {
				class_1703 screenHandler = handledScreen.method_17577();
				if (screenHandler instanceof BuiltScreenHandler builtScreenHandler) {
					builtScreenHandler.applyScreenHandlerData(payload.data());
				}
			}
		});

		ClientPlayNetworking.registerGlobalReceiver(ChunkSyncPayload.ID, (payload, context) -> ClientChunkManager.setLoadedChunks(payload.chunks()));
		ClientPlayNetworking.registerGlobalReceiver(QueueItemStacksPayload.ID, (payload, context) -> ItemStackRenderManager.RENDER_QUEUE.addAll(payload.stacks()));
	}
}
