/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldExtractionContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_12074;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import net.minecraft.class_863;
import org.jetbrains.annotations.Nullable;
import reborncore.common.misc.MultiBlockBreakingTool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BlockOutlineRenderer implements WorldRenderEvents.BeforeBlockOutline, WorldRenderEvents.AfterBlockOutlineExtraction {
	public static RenderStateDataKey<List<class_265>> KEY = RenderStateDataKey.create(() -> "MultiBlockBreakingTool");
	@Override
	public void afterBlockOutlineExtraction(WorldExtractionContext context, @Nullable class_239 result) {
		if (result instanceof class_3965 blockHitResult) {
			class_746 player = class_310.method_1551().field_1724;
			if (player == context.camera().method_19331()) {
				class_1799 stack = player.method_6047();
				if (!stack.method_7960() && stack.method_7909() instanceof MultiBlockBreakingTool tool) {
					class_2338 targetPos = blockHitResult.method_17777();
					class_1937 level = player.method_73183();
					Set<class_2338> blockPosList = tool.getBlocksToBreak(stack, level, targetPos, player);
					List<class_265> shapes = new ArrayList<>();
					for (class_2338 pos : blockPosList) {
						if (pos.equals(targetPos)) {
							continue;
						}
						class_2680 blockState = level.method_8320(pos);
						shapes.add(blockState.method_26172(level, pos, class_3726.method_16195(player)).method_1096(pos.method_10263() - targetPos.method_10263(), pos.method_10264() - targetPos.method_10264(), pos.method_10260() - targetPos.method_10260()));
					}
					if (shapes.isEmpty()) {
						return;
					}
					context.worldState().field_63083.setData(KEY, shapes);
				}
			}
		}
	}

	@Override
	public boolean beforeBlockOutline(WorldRenderContext worldRenderContext, class_12074 context) {
		List<class_265> shapes = context.getData(KEY);
		if (shapes != null) {
			class_265 shape = context.comp_4935();

			for (class_265 voxelShape : shapes) {
				shape = class_259.method_1084(shape, voxelShape);
			}

			class_2338 targetPos = context.comp_4932();
			class_243 camera = worldRenderContext.worldState().field_63082.field_63078;
			class_863.method_62350(worldRenderContext.matrices(), worldRenderContext.consumers().method_73477(class_1921.method_23594()), shape, (double)targetPos.method_10263() - camera.field_1352, (double)targetPos.method_10264() - camera.field_1351, (double)targetPos.method_10260() - camera.field_1350, 0.0F, 0.0F, 0.0F, 0.4F, true);
		}

		return true;
	}
}
