/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.api.items;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public abstract class InventoryBase implements class_1263 {

	private final int size;
	private class_2371<class_1799> stacks;

	public InventoryBase(int size) {
		this.size = size;
		stacks = class_2371.method_10213(size, class_1799.field_8037);
	}

	public void writeData(class_11372 view) {
		class_1262.method_5426(view, stacks);
	}

	public void readData(class_11368 view) {
		stacks = class_2371.method_10213(size, class_1799.field_8037);
		class_1262.method_5429(view, stacks);
	}

	@Override
	public int method_5439() {
		return size;
	}

	@Override
	public boolean method_5442() {
		return stacks.stream().allMatch(class_1799::method_7960);
	}

	@Override
	public class_1799 method_5438(int i) {
		return stacks.get(i);
	}

	@Override
	public class_1799 method_5434(int i, int i1) {
		class_1799 stack = class_1262.method_5430(stacks, i, i1);
		if (!stack.method_7960()) {
			this.method_5431();
		}
		return stack;
	}

	@Override
	public class_1799 method_5441(int i) {
		return class_1262.method_5428(stacks, i);
	}

	@Override
	public void method_5447(int i, class_1799 itemStack) {
		stacks.set(i, itemStack);
		if (itemStack.method_7947() > this.method_5444()) {
			itemStack.method_7939(this.method_5444());
		}

		this.method_5431();
	}

	@Override
	public void method_5431() {
		// Stuff happens in the super methods
	}

	@Override
	public boolean method_5443(class_1657 playerEntity) {
		return true;
	}

	@Override
	public void method_5448() {
		stacks.clear();
	}

	public class_2371<class_1799> getStacks() {
		return stacks;
	}
}
