/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.api;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

/**
 * Added onto an item
 */
public interface IToolHandler {

	/**
	 * Called when a machine is activated with the item that has {@link IToolHandler} on it
	 *
	 * @param stack  {@link class_1799} The held itemstack
	 * @param pos    {@link class_2338} The pos of the block
	 * @param world  {@link class_1937} The world of the block
	 * @param player {@link class_1657} The player that activated the block
	 * @param side   {@link class_2350} The side that the player activated
	 * @param damage {@code boolean} If the tool should be damaged, or power taken
	 * @return {@code boolean} If the tool can handle being activated on the block,
	 * return false when the tool is broken or out of power for example.
	 */
	boolean handleTool(class_1799 stack, class_2338 pos, class_1937 world, class_1657 player, class_2350 side, boolean damage);

}
