/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore;

import org.apache.commons.lang3.Validate;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

/**
 * Created by Gigabit101 on 16/08/2016.
 */
public class RebornRegistry {
	//Yeah, this is horrible
	private static final HashMap<Object, class_2960> objIdentMap = new HashMap<>();

	/**
	 * Registers {@link class_2248} and {@link class_1747} in vanilla registries
	 *
	 * @param block   {@link class_2248} Block to register
	 * @param settings {@link class_1792.class_1793} Settings settings for {@link class_1747}
	 * @param name    {@link class_2960} Registry name for block and item
	 */
	public static void registerBlock(class_2248 block, class_1792.class_1793 settings, class_2960 name) {
		class_2378.method_10230(class_7923.field_41175, name, block);
		class_1747 itemBlock = new class_1747(block, settings);
		class_2378.method_10230(class_7923.field_41178, name, itemBlock);
	}

	public static void registerBlock(class_2248 block, Function<class_2248, class_1747> blockItemFunction, class_2960 name) {
		class_2378.method_10230(class_7923.field_41175, name, block);
		class_1747 itemBlock = blockItemFunction.apply(block);
		class_2378.method_10230(class_7923.field_41178, name, itemBlock);
	}

	/**
	 * Registers Block and BlockItem in vanilla registries.
	 * Block should have registered identifier in RebornRegistry via {@link #registerIdent registerIdent} method
	 *
	 * @param block     {@link class_2248} Block to register
	 * @param itemGroup {@link class_1792.class_1793} Settings settings for {@link class_1747}
	 */
	public static void registerBlock(class_2248 block, class_1792.class_1793 itemGroup) {
		Validate.isTrue(objIdentMap.containsKey(block));
		registerBlock(block, itemGroup, objIdentMap.get(block));
	}

	public static void registerBlock(class_2248 block, Function<class_2248, class_1747> blockItemFunction){
		Validate.isTrue(objIdentMap.containsKey(block));
		registerBlock(block, blockItemFunction, objIdentMap.get(block));
	}

	/**
	 * Register only {@link class_2248}, without {@link class_1747} in vanilla registries
	 * Block should have registered identifier in {@link RebornRegistry} via
	 * {@link #registerIdent registerIdent} method
	 *
	 * @param block {@link class_2248} Block to register
	 */
	public static void registerBlockNoItem(class_2248 block) {
		Validate.isTrue(objIdentMap.containsKey(block));
		class_2378.method_10230(class_7923.field_41175, objIdentMap.get(block), block);
	}


	/**
	 * Register {@link class_1792} in vanilla registries
	 *
	 * @param item {@link class_1792} Item to register
	 * @param name {@link class_2960} Registry name for item
	 */
	public static void registerItem(class_1792 item, class_2960 name) {
		class_2378.method_10230(class_7923.field_41178, name, item);
	}

	/**
	 * <p>Register {@link class_1792} in vanilla registries</p>
	 * <p>
	 *  {@link class_1792} should have registered identifier in {@link RebornRegistry}
	 *  via {@link #registerIdent registerIdent} method
	 * </p>
	 *
	 * @param item {@link class_1792} Item to register
	 */
	public static void registerItem(class_1792 item){
		Validate.isTrue(objIdentMap.containsKey(item));
		registerItem(item, objIdentMap.get(item));
	}

	/**
	 * Registers {@link class_2960} in internal RebornCore map
	 *
	 * @param object     {@link Object}, {@link class_1792}, {@link class_2248} or whatever to be put into map
	 * @param identifier {@link class_2960} Registry name for object
	 */
	public static void registerIdent(Object object, class_2960 identifier){
		objIdentMap.put(object, identifier);
	}
}
