/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2338;

public class Torus {
    private static final ExecutorService GEN_EXECUTOR = Executors.newSingleThreadExecutor();
    private static Int2IntMap torusSizeCache;

    public static List<class_2338> generate(class_2338 orgin, int radius) {
        ArrayList<class_2338> posLists = new ArrayList<class_2338>();
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    if (!(Math.pow((double)(radius / 2) - Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)), 2.0) + Math.pow(z, 2.0) < Math.pow((double)radius * 0.05, 2.0))) continue;
                    posLists.add(orgin.method_10069(x, z, y));
                }
            }
        }
        return posLists;
    }

    public static void genSizeMap(int maxRadius) {
        if (torusSizeCache != null) {
            return;
        }
        int sizeToCompute = maxRadius + 10;
        torusSizeCache = new Int2IntOpenHashMap(sizeToCompute);
        int i = 0;
        while (i < sizeToCompute) {
            int radius = i++;
            GEN_EXECUTOR.submit(() -> {
                int size = 0;
                for (int x = -radius; x < radius; ++x) {
                    for (int y = -radius; y < radius; ++y) {
                        for (int z = -radius; z < radius; ++z) {
                            if (!(Math.pow((double)(radius / 2) - Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)), 2.0) + Math.pow(z, 2.0) < Math.pow((double)radius * 0.05, 2.0))) continue;
                            ++size;
                        }
                    }
                }
                torusSizeCache.put(radius, size);
            });
        }
        GEN_EXECUTOR.shutdown();
    }

    public static Int2IntMap getTorusSizeCache() {
        if (!GEN_EXECUTOR.isShutdown()) {
            try {
                GEN_EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Reborn core failed to initialize the torus cache", e);
            }
        }
        return torusSizeCache;
    }
}

