/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IListInfoProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergySide;
import team.reborn.energy.EnergyStorage;
import team.reborn.energy.EnergyTier;

public abstract class PowerAcceptorBlockEntity
extends MachineBaseBlockEntity
implements EnergyStorage,
IListInfoProvider {
    private EnergyTier blockEntityPowerTier;
    private double energy;
    public double extraPowerStorage;
    public double extraPowerInput;
    public int extraTier;
    public double powerChange;
    public double powerLastTick;
    public boolean checkOverfill = true;

    public PowerAcceptorBlockEntity(class_2591<?> blockEntityType) {
        super(blockEntityType);
        this.checkTier();
    }

    public void checkTier() {
        this.blockEntityPowerTier = this.getMaxInput(EnergySide.UNKNOWN) == 0.0 ? PowerAcceptorBlockEntity.getTier((int)this.getBaseMaxOutput()) : PowerAcceptorBlockEntity.getTier((int)this.getBaseMaxInput());
    }

    public static EnergyTier getTier(int power) {
        for (EnergyTier tier : EnergyTier.values()) {
            if (tier.getMaxInput() < power) continue;
            return tier;
        }
        return EnergyTier.INFINITE;
    }

    public double getFreeSpace() {
        return this.getMaxStoredPower() - this.getStored(EnergySide.UNKNOWN);
    }

    public void addEnergy(double amount) {
        this.setStored(this.energy + amount);
    }

    public void useEnergy(double amount) {
        if (this.energy > amount) {
            this.setStored(this.energy - amount);
        } else {
            this.setStored(0.0);
        }
    }

    public void charge(int slot) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        double chargeEnergy = Math.min(this.getFreeSpace(), this.getMaxInput(EnergySide.UNKNOWN));
        if (chargeEnergy <= 0.0) {
            return;
        }
        if (!this.getOptionalInventory().isPresent()) {
            return;
        }
        class_1799 batteryStack = this.getOptionalInventory().get().method_5438(slot);
        if (batteryStack.method_7960()) {
            return;
        }
        if (Energy.valid((Object)batteryStack)) {
            Energy.of((Object)batteryStack).into(Energy.of((Object)this)).move();
        }
    }

    public void discharge(int slot) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (!this.getOptionalInventory().isPresent()) {
            return;
        }
        class_1799 batteryStack = this.getOptionalInventory().get().method_5438(slot);
        if (batteryStack.method_7960()) {
            return;
        }
        if (Energy.valid((Object)batteryStack)) {
            Energy.of((Object)this).into(Energy.of((Object)batteryStack)).move((double)this.getTier().getMaxOutput());
        }
    }

    public static int calculateComparatorOutputFromEnergy(@Nullable class_2586 blockEntity) {
        if (blockEntity instanceof PowerAcceptorBlockEntity) {
            PowerAcceptorBlockEntity storage = (PowerAcceptorBlockEntity)blockEntity;
            return class_3532.method_15384((double)(storage.getStored(EnergySide.UNKNOWN) * 15.0 / storage.getMaxStoredPower()));
        }
        return 0;
    }

    protected boolean shouldHandleEnergyNBT() {
        return true;
    }

    protected boolean canAcceptEnergy(EnergySide side) {
        return true;
    }

    protected boolean canProvideEnergy(EnergySide side) {
        return true;
    }

    @Deprecated
    public boolean canAcceptEnergy(class_2350 direction) {
        return true;
    }

    @Deprecated
    public boolean canProvideEnergy(class_2350 direction) {
        return true;
    }

    public double getExtraPowerStorage() {
        return this.extraPowerStorage;
    }

    public void setExtraPowerStorage(double extraPowerStorage) {
        this.extraPowerStorage = extraPowerStorage;
    }

    public double getPowerChange() {
        return this.powerChange;
    }

    public void setPowerChange(double powerChange) {
        this.powerChange = powerChange;
    }

    public double getEnergy() {
        return this.getStored(EnergySide.UNKNOWN);
    }

    public void setEnergy(double energy) {
        this.setStored(energy);
    }

    public abstract double getBaseMaxPower();

    public abstract double getBaseMaxOutput();

    public abstract double getBaseMaxInput();

    @Override
    public void method_16896() {
        super.method_16896();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.getStored(EnergySide.UNKNOWN) <= 0.0) {
            return;
        }
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        for (class_2350 side : class_2350.values()) {
            class_2586 blockEntity = this.field_11863.method_8321(this.method_11016().method_10093(side));
            if (blockEntity == null || !Energy.valid((Object)blockEntity)) continue;
            Energy.of((Object)this).side(side).into(Energy.of((Object)blockEntity).side(side.method_10153())).move();
        }
        this.powerChange = this.getStored(EnergySide.UNKNOWN) - this.powerLastTick;
        this.powerLastTick = this.getStored(EnergySide.UNKNOWN);
    }

    @Override
    public void method_11014(class_2680 blockState, class_2487 tag) {
        super.method_11014(blockState, tag);
        class_2487 data = tag.method_10562("PowerAcceptor");
        if (this.shouldHandleEnergyNBT()) {
            this.setStored(data.method_10574("energy"));
        }
    }

    @Override
    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 data = new class_2487();
        data.method_10549("energy", this.getStored(EnergySide.UNKNOWN));
        tag.method_10566("PowerAcceptor", (class_2520)data);
        return tag;
    }

    @Override
    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraPowerStorage = 0.0;
        this.extraTier = 0;
        this.extraPowerInput = 0.0;
    }

    public double getStored(EnergySide face) {
        return this.energy;
    }

    public void setStored(double amount) {
        this.energy = amount;
        if (this.checkOverfill) {
            this.energy = Math.max(Math.min(this.energy, this.getMaxStoredPower()), 0.0);
        }
        this.method_5431();
    }

    public double getMaxStoredPower() {
        return this.getBaseMaxPower() + this.extraPowerStorage;
    }

    public double getMaxOutput(EnergySide face) {
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return 0.0;
        }
        if (!this.canProvideEnergy(face)) {
            return 0.0;
        }
        if (this.extraTier > 0) {
            return this.getTier().getMaxOutput();
        }
        return this.getBaseMaxOutput();
    }

    public double getMaxInput(EnergySide face) {
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return 0.0;
        }
        if (!this.canAcceptEnergy(face)) {
            return 0.0;
        }
        if (this.extraTier > 0) {
            return this.getTier().getMaxInput();
        }
        return this.getBaseMaxInput() + this.extraPowerInput;
    }

    public EnergyTier getTier() {
        if (this.blockEntityPowerTier == null) {
            this.checkTier();
        }
        if (this.extraTier > 0) {
            for (EnergyTier enumTier : EnergyTier.values()) {
                if (enumTier.ordinal() != this.blockEntityPowerTier.ordinal() + this.extraTier) continue;
                return enumTier;
            }
            return EnergyTier.INFINITE;
        }
        return this.blockEntityPowerTier;
    }

    @Override
    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (!isReal && hasData) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.energy)).method_27692(class_124.field_1065));
        }
        info.add((class_2561)new class_2588("reborncore.tooltip.energy.maxEnergy").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getMaxStoredPower())).method_27692(class_124.field_1065));
        if (this.getMaxInput(EnergySide.UNKNOWN) != 0.0) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy.inputRate").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getMaxInput(EnergySide.UNKNOWN))).method_27692(class_124.field_1065));
        }
        if (this.getMaxOutput(EnergySide.UNKNOWN) > 0.0) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy.outputRate").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getMaxOutput(EnergySide.UNKNOWN))).method_27692(class_124.field_1065));
        }
        info.add((class_2561)new class_2588("reborncore.tooltip.energy.tier").method_27692(class_124.field_1080).method_27693(": ").method_27693(StringUtils.toFirstCapitalAllLowercase(this.getTier().toString())).method_27692(class_124.field_1065));
        if (isReal) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy.change").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.powerChange)).method_27693("/t").method_27692(class_124.field_1065));
        }
        super.addInfo(info, isReal, hasData);
    }
}

