/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import org.apache.commons.lang3.Validate;
import reborncore.api.items.InventoryBase;

import org.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class InventoryItem extends InventoryBase {

	@NotNull
	class_1799 stack;
	int size;

	private InventoryItem(
			@NotNull
					class_1799 stack, int size) {
		super(size);
		Validate.notNull(stack);
		Validate.isTrue(!stack.method_7960());
		this.size = size;
		this.stack = stack;
	}

	public static InventoryItem getItemInvetory(class_1799 stack, int size) {
		return new InventoryItem(stack, size);
	}

	public class_1799 getStack() {
		return stack;
	}

	public class_2487 getInvData() {
		Validate.isTrue(!stack.method_7960());
		if (!stack.method_7985()) {
			stack.method_7980(new class_2487());
		}
		if (!stack.method_7969().method_10545("inventory")) {
			stack.method_7969().method_10566("inventory", new class_2487());
		}
		return stack.method_7969().method_10562("inventory");
	}

	public class_2487 getSlotData(int slot) {
		validateSlotIndex(slot);
		class_2487 invData = getInvData();
		if (!invData.method_10545("slot_" + slot)) {
			invData.method_10566("slot_" + slot, new class_2487());
		}
		return invData.method_10562("slot_" + slot);
	}

	public void setSlotData(int slot, class_2487 tagCompound) {
		validateSlotIndex(slot);
		Validate.notNull(tagCompound);
		class_2487 invData = getInvData();
		invData.method_10566("slot_" + slot, tagCompound);
	}

	public List<class_1799> getAllStacks() {
		return IntStream.range(0, size)
				.mapToObj(this::method_5438)
				.collect(Collectors.toList());
	}

	public int getSlots() {
		return size;
	}

	@NotNull
	@Override
	public class_1799 method_5438(int slot) {
		return class_1799.method_7915(getSlotData(slot));
	}

	@Override
	public void method_5447(int slot,
						 @NotNull
								 class_1799 stack) {
		setSlotData(slot, stack.method_7953(new class_2487()));
	}

	public int getSlotLimit(int slot) {
		return 64;
	}

	public void validateSlotIndex(int slot) {
		if (slot < 0 || slot >= size) {
			throw new RuntimeException("Slot " + slot + " not in valid range - [0," + size + ")");
		}

	}

	public int getStackLimit(int slot,
							 @NotNull
									 class_1799 stack) {
		return Math.min(getSlotLimit(slot), stack.method_7914());
	}

	@Override
	public boolean method_5437(int slot, class_1799 stack) {
		return true;
	}

}
