/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.fluid.container;

import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import reborncore.common.fluid.FluidValue;
import reborncore.common.util.NBTSerializable;

public class FluidInstance implements NBTSerializable {
	public static final String FLUID_KEY = "Fluid";
	public static final String AMOUNT_KEY = "Amount";
	public static final String TAG_KEY = "Tag";

	public static final FluidInstance EMPTY = new FluidInstance(class_3612.field_15906, FluidValue.EMPTY);

	protected class_3611 fluid;
	protected FluidValue amount;
	protected class_2487 tag;

	public FluidInstance(class_3611 fluid, FluidValue amount) {
		this.fluid = fluid;
		this.amount = amount;
	}

	public FluidInstance(class_3611 fluid) {
		this(fluid, FluidValue.EMPTY);
	}

	public FluidInstance() {
		this(class_3612.field_15906);
	}

	public FluidInstance(class_2487 tag) {
		this();
		read(tag);
	}

	public class_3611 getFluid() {
		return fluid;
	}

	public FluidValue getAmount() {
		return amount;
	}

	public class_2487 getTag() {
		return tag;
	}

	public FluidInstance setFluid(class_3611 fluid) {
		this.fluid = fluid;
		return this;
	}

	public FluidInstance setAmount(FluidValue value) {
		this.amount = value;
		return this;
	}

	public FluidInstance subtractAmount(FluidValue amount) {
		this.amount = this.amount.subtract(amount);
		return this;
	}

	public FluidInstance addAmount(FluidValue amount) {
		this.amount = this.amount.add(amount);
		return this;
	}

	public void setTag(class_2487 tag) {
		this.tag = tag;
	}

	public boolean isEmpty() {
		return isEmptyFluid() || this.getAmount().isEmpty();
	}

	public boolean isEmptyFluid() {
		return this.getFluid() == class_3612.field_15906;
	}

	public FluidInstance copy() {
		return new FluidInstance().setFluid(fluid).setAmount(amount);
	}

	@Override
	public class_2487 write() {
		class_2487 tag = new class_2487();
		tag.method_10582(FLUID_KEY, class_2378.field_11154.method_10221(fluid).toString());
		tag.method_10569(AMOUNT_KEY, amount.getRawValue());
		if (this.tag != null && !this.tag.isEmpty()) {
			tag.method_10566(TAG_KEY, this.tag);
		}
		return tag;
	}

	@Override
	public void read(class_2487 tag) {
		fluid = class_2378.field_11154.method_10223(new class_2960(tag.method_10558(FLUID_KEY)));
		amount = FluidValue.fromRaw(tag.method_10550(AMOUNT_KEY));
		if (tag.method_10545(TAG_KEY)) {
			this.tag = tag.method_10562(TAG_KEY);
		}
	}

	@Override
	public boolean equals(Object obj) {
		return obj instanceof FluidInstance && fluid == ((FluidInstance) obj).getFluid() && amount.equals(((FluidInstance) obj).getAmount());
	}

	public boolean isFluidEqual(FluidInstance instance) {
		return (isEmpty() && instance.isEmpty()) || fluid.equals(instance.getFluid());
	}
}