/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.fluid;

import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.apache.commons.lang3.StringUtils;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.Tank;

import org.jetbrains.annotations.NotNull;


public class FluidUtil {

	@Deprecated
	public static FluidInstance getFluidHandler(class_1799 stack) {
		return null;
	}

	@Deprecated
	public static boolean interactWithFluidHandler(class_1657 playerIn, class_1268 hand, Tank tank) {
		return false;
	}

	@Deprecated
	public static class_1799 getFilledBucket(FluidInstance stack) {
		return null;
	}

	public static String getFluidName(@NotNull FluidInstance fluidInstance) {
		return getFluidName(fluidInstance.getFluid());
	}

	public static String getFluidName(@NotNull class_3611 fluid) {
		return StringUtils.capitalize(class_2378.field_11154.method_10221(fluid).method_12832());
	}

	public static void transferFluid(Tank source, Tank destination, FluidValue amount) {
		if (source == null || destination == null) {
			return;
		}
		if (source.getFluid() == class_3612.field_15906 || source.getFluidAmount().isEmpty()) {
			return;
		}
		if (destination.getFluid() != class_3612.field_15906 && source.getFluid() != destination.getFluid()) {
			return;
		}
		FluidValue transferAmount = source.getFluidAmount().min(amount);
		if (destination.getFreeSpace().equalOrMoreThan(transferAmount)) {
			FluidInstance fluidInstance = destination.getFluidInstance();
			if (fluidInstance.isEmpty()) {
				fluidInstance = new FluidInstance(source.getFluid(), transferAmount);
			} else {
				fluidInstance.addAmount(transferAmount);
			}
			source.setFluidAmount(source.getFluidAmount().subtract(transferAmount));
			destination.setFluidInstance(fluidInstance);

			if (source.getFluidAmount().equals(FluidValue.EMPTY)) {
				source.setFluid(class_3612.field_15906);
			}
		}
	}
}
