/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.ServerBoundPackets;

import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class ClientChunkManager {

	private static final List<ChunkLoaderManager.LoadedChunk> loadedChunks = new ArrayList<>();

	public static void setLoadedChunks(List<ChunkLoaderManager.LoadedChunk> chunks) {
		loadedChunks.clear();
		loadedChunks.addAll(chunks);
	}

	public static void toggleLoadedChunks(class_2338 chunkLoader) {
		if (loadedChunks.size() == 0) {
			NetworkManager.sendToServer(ServerBoundPackets.requestChunkloaderChunks(chunkLoader));
		} else {
			loadedChunks.clear();
		}
	}

	public static boolean hasChunksForLoader(class_2338 pos) {
		return loadedChunks.stream()
				.filter(loadedChunk -> loadedChunk.getChunkLoader().equals(pos))
				.anyMatch(loadedChunk -> loadedChunk.getWorld().equals(ChunkLoaderManager.getWorldName(class_310.method_1551().field_1687)));
	}

	public static void render(class_4587 matrices, class_4597 vertexConsumers, double x, double y, double z) {
		if (loadedChunks.size() == 0) {
			return;
		}
		final class_310 minecraftClient = class_310.method_1551();

		RenderSystem.enableDepthTest();
		RenderSystem.shadeModel(7425);
		RenderSystem.enableAlphaTest();
		RenderSystem.defaultAlphaFunc();

		final class_289 tessellator = class_289.method_1348();
		final class_287 bufferBuilder = tessellator.method_1349();

		RenderSystem.disableTexture();
		RenderSystem.disableBlend();
		RenderSystem.lineWidth(5.0F);

		bufferBuilder.method_1328(3, class_290.field_1576);

		loadedChunks.stream()
				.filter(loadedChunk -> loadedChunk.getWorld().equals(ChunkLoaderManager.getWorldName(minecraftClient.field_1687)))
				.forEach(loadedChunk -> {
					double chunkX = (double) loadedChunk.getChunk().method_8326() - x;
					double chunkY = (double) loadedChunk.getChunk().method_8328() - z;

					bufferBuilder.method_22912(chunkX + 8, 0.0D - y, chunkY + 8).method_22915(1.0F, 0.0F, 0.0F, 0.0F).method_1344();
					bufferBuilder.method_22912(chunkX + 8, 0.0D - y, chunkY + 8).method_22915(1.0F, 0.0F, 0.0F, 0.5F).method_1344();
					bufferBuilder.method_22912(chunkX + 8, 256.0D - y, chunkY + 8).method_22915(1.0F, 0.0F, 0.0F, 0.5F).method_1344();
					bufferBuilder.method_22912(chunkX + 8, 256.0D - y, chunkY + 8).method_22915(1.0F, 0.0F, 0.0F, 0.0F).method_1344();
				});

		tessellator.method_1350();
		RenderSystem.lineWidth(1.0F);
		RenderSystem.enableBlend();
		RenderSystem.enableTexture();
	}

}
