/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import reborncore.common.recipes.IRecipeInput;
import reborncore.common.util.ChatUtils;
import team.reborn.energy.Energy;

public class ItemUtils {
    public static boolean isItemEqual(class_1799 a, class_1799 b, boolean matchNBT) {
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (a.method_7909() != b.method_7909()) {
            return false;
        }
        return !matchNBT || class_1799.method_7975((class_1799)a, (class_1799)b);
    }

    public static boolean isItemEqual(class_1799 a, class_1799 b, boolean matchNBT, boolean useTags) {
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual(a, b, matchNBT)) {
            return true;
        }
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (useTags) {
            // empty if block
        }
        return false;
    }

    public static boolean isInputEqual(Object input, class_1799 other, boolean matchNBT, boolean useTags) {
        if (input instanceof class_1799) {
            return ItemUtils.isItemEqual((class_1799)input, other, matchNBT, useTags);
        }
        if (!(input instanceof String) && input instanceof IRecipeInput) {
            List<class_1799> inputs = ((IRecipeInput)input).getAllStacks();
            for (class_1799 stack : inputs) {
                if (!ItemUtils.isItemEqual(stack, other, matchNBT, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static void writeItemToNBT(class_1799 stack, class_2487 data) {
        if (stack.method_7960() || stack.method_7947() <= 0) {
            return;
        }
        if (stack.method_7947() > 127) {
            stack.method_7939(127);
        }
        stack.method_7953(data);
    }

    public static class_1799 readItemFromNBT(class_2487 data) {
        return class_1799.method_7915((class_2487)data);
    }

    public static double getPowerForDurabilityBar(class_1799 stack) {
        if (stack.method_7960()) {
            return 0.0;
        }
        if (!Energy.valid((Object)stack)) {
            return 0.0;
        }
        return Energy.of((Object)stack).getEnergy() / Energy.of((Object)stack).getMaxStored();
    }

    public static boolean isActive(class_1799 stack) {
        return !stack.method_7960() && stack.method_7969() != null && stack.method_7969().method_10577("isActive");
    }

    public static void checkActive(class_1799 stack, int cost, boolean isClient, int messageId) {
        if (!ItemUtils.isActive(stack)) {
            return;
        }
        if (Energy.of((Object)stack).getEnergy() >= (double)cost) {
            return;
        }
        if (isClient) {
            ChatUtils.sendNoSpamMessages(messageId, (class_2561)new class_2588("reborncore.message.energyError").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("reborncore.message.deactivating").method_27692(class_124.field_1065)));
        }
        stack.method_7948().method_10556("isActive", false);
    }

    public static void switchActive(class_1799 stack, int cost, boolean isClient, int messageId) {
        ItemUtils.checkActive(stack, cost, isClient, messageId);
        if (!ItemUtils.isActive(stack)) {
            stack.method_7948().method_10556("isActive", true);
            if (isClient) {
                ChatUtils.sendNoSpamMessages(messageId, (class_2561)new class_2588("reborncore.message.setTo").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("reborncore.message.active").method_27692(class_124.field_1065)));
            }
        } else {
            stack.method_7948().method_10556("isActive", false);
            if (isClient) {
                ChatUtils.sendNoSpamMessages(messageId, (class_2561)new class_2588("reborncore.message.setTo").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("reborncore.message.inactive").method_27692(class_124.field_1065)));
            }
        }
    }

    public static void buildActiveTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (!ItemUtils.isActive(stack)) {
            tooltip.add((class_2561)new class_2588("reborncore.message.inactive").method_27692(class_124.field_1061));
        } else {
            tooltip.add((class_2561)new class_2588("reborncore.message.active").method_27692(class_124.field_1060));
        }
    }

    public static void distributePowerToInventory(class_1657 player, class_1799 itemStack, int maxOutput) {
        ItemUtils.distributePowerToInventory(player, itemStack, maxOutput, stack -> true);
    }

    public static void distributePowerToInventory(class_1657 player, class_1799 itemStack, int maxOutput, Predicate<class_1799> filter) {
        if (!Energy.valid((Object)itemStack)) {
            return;
        }
        for (int i = 0; i < player.field_7514.method_5439(); ++i) {
            class_1799 invStack = player.field_7514.method_5438(i);
            if (invStack.method_7960() || !filter.test(invStack) || !Energy.valid((Object)invStack)) continue;
            Energy.of((Object)itemStack).into(Energy.of((Object)invStack)).move((double)maxOutput);
        }
    }
}

