/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.multiblock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import reborncore.RebornCore;
import reborncore.api.blockentity.UnloadHandler;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockRegistry;

public abstract class MultiblockBlockEntityBase
extends IMultiblockPart
implements class_3000,
UnloadHandler {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private class_2487 cachedMultiblockData = null;

    public MultiblockBlockEntityBase(class_2591<?> tBlockEntityType) {
        super(tBlockEntityType);
    }

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            RebornCore.LOGGER.info(String.format("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()));
            this.controller = null;
        }
    }

    public void method_11014(class_2680 blockState, class_2487 data) {
        super.method_11014(blockState, data);
        if (data.method_10545("multiblockData")) {
            this.cachedMultiblockData = data.method_10562("multiblockData");
        }
    }

    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            class_2487 multiblockData = new class_2487();
            this.controller.write(multiblockData);
            data.method_10566("multiblockData", (class_2520)multiblockData);
        }
        return data;
    }

    public void method_11012() {
        this.detachSelf(false);
        super.method_11012();
    }

    @Override
    public void onUnload() {
        this.detachSelf(true);
    }

    public void method_10996() {
        super.method_10996();
        MultiblockRegistry.onPartAdded(this.method_10997(), this);
    }

    public class_2622 method_16886() {
        class_2487 packetData = new class_2487();
        this.encodeDescriptionPacket(packetData);
        return new class_2622(this.method_11016(), 0, packetData);
    }

    protected void encodeDescriptionPacket(class_2487 packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            class_2487 tag = new class_2487();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.method_10566("multiblockData", (class_2520)tag);
        }
    }

    protected void decodeDescriptionPacket(class_2487 packetData) {
        if (packetData.method_10545("multiblockData")) {
            class_2487 tag = packetData.method_10562("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public class_2487 getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public class_2338 getWorldLocation() {
        return this.method_11016();
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        class_2338 partPosition = this.getWorldLocation();
        for (class_2350 facing : class_2350.values()) {
            class_2338 neighborPosition = partPosition.method_10093(facing);
            class_2586 te = this.field_11863.method_8321(neighborPosition);
            if (!(te instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        return neighborParts.toArray(new IMultiblockPart[neighborParts.size()]);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.method_5431();
        this.method_10997().method_8524(this.method_11016(), (class_2586)this);
    }

    protected void notifyNeighborsOfBlockChange() {
        this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
    }

    protected void notifyNeighborsOfBlockEntityChange() {
        this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.method_10997(), this);
    }

    @Override
    public class_2680 method_11010() {
        return this.field_11863.method_8320(this.field_11867);
    }
}

