/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_5323;
import org.apache.commons.lang3.Validate;
import reborncore.common.crafting.ingredient.IngredientManager;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.ingredient.SimpleTag;

public class TagIngredient
extends RebornIngredient {
    private final class_2960 tagIdentifier;
    private final class_3494<class_1792> tag;
    private final Optional<Integer> count;

    public TagIngredient(class_2960 tagIdentifier, class_3494<class_1792> tag, Optional<Integer> count) {
        super(IngredientManager.TAG_RECIPE_TYPE);
        this.tagIdentifier = tagIdentifier;
        this.tag = tag;
        this.count = count;
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (this.count.isPresent() && this.count.get() > itemStack.method_7947()) {
            return false;
        }
        return itemStack.method_7909().method_7855(this.tag);
    }

    @Override
    public class_1856 getPreview() {
        return class_1856.method_26964(this.getPreviewStacks().stream());
    }

    @Override
    public List<class_1799> getPreviewStacks() {
        return this.tag.method_15138().stream().map(class_1799::new).peek(itemStack -> itemStack.method_7939(this.count.orElse(1).intValue())).collect(Collectors.toList());
    }

    public static RebornIngredient deserialize(JsonObject json) {
        Optional<Integer> count = Optional.empty();
        if (json.has("count")) {
            count = Optional.of(class_3518.method_15260((JsonObject)json, (String)"count"));
        }
        if (json.has("server_sync")) {
            class_2960 tagIdent = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag_identifier"));
            ArrayList<class_1792> items = new ArrayList<class_1792>();
            for (int i = 0; i < class_3518.method_15260((JsonObject)json, (String)"items"); ++i) {
                class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)("item_" + i)));
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(identifier);
                Validate.isTrue((item != class_1802.field_8162 ? 1 : 0) != 0, (String)"item cannot be air", (Object[])new Object[0]);
                items.add(item);
            }
            return new TagIngredient(tagIdent, new SimpleTag<class_1792>(items), count);
        }
        class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
        class_3494 tag = class_5323.method_29223().method_30218().method_30210(identifier);
        if (tag == null) {
            throw new JsonSyntaxException("Unknown item tag '" + identifier + "'");
        }
        return new TagIngredient(identifier, (class_3494<class_1792>)tag, count);
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server_sync", Boolean.valueOf(true));
        class_1792[] items = this.tag.method_15138().toArray(new class_1792[0]);
        jsonObject.addProperty("items", (Number)items.length);
        for (int i = 0; i < items.length; ++i) {
            jsonObject.addProperty("item_" + i, class_2378.field_11142.method_10221((Object)items[i]).toString());
        }
        this.count.ifPresent(integer -> jsonObject.addProperty("count", (Number)integer));
        jsonObject.addProperty("tag_identifier", this.tagIdentifier.toString());
        return jsonObject;
    }

    @Override
    public int getCount() {
        return this.count.orElse(1);
    }
}

