/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.blocks;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3614;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import reborncore.api.ToolManager;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.api.items.InventoryUtils;
import reborncore.common.BaseBlockEntityProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.fluid.FluidUtil;
import reborncore.common.util.ItemHandlerUtils;
import reborncore.common.util.Tank;
import reborncore.common.util.WrenchUtils;

public abstract class BlockMachineBase extends BaseBlockEntityProvider implements class_3954 {

	public static final class_2753 FACING = class_2741.field_12481;
	public static final class_2746 ACTIVE = class_2746.method_11825("active");

	boolean hasCustomStates;

	public BlockMachineBase() {
		this(class_2248.Settings.method_9637(class_3614.field_15953).method_9629(2F, 2F));
	}

	public BlockMachineBase(class_2248.Settings builder) {
		this(builder, false);
	}

	public BlockMachineBase(class_2248.Settings builder, boolean hasCustomStates) {
		super(builder);
		this.hasCustomStates = hasCustomStates;
		if (!hasCustomStates) {
			this.method_9590(
					this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(ACTIVE, false));
		}
		BlockWrenchEventHandler.wrenableBlocks.add(this);
	}

	public void setFacing(class_2350 facing, class_1937 world, class_2338 pos) {
		if (hasCustomStates) {
			return;
		}
		world.method_8501(pos, world.method_8320(pos).method_11657(FACING, facing));
	}

	public class_2350 getFacing(class_2680 state) {
		return state.method_11654(FACING);
	}

	public void setActive(Boolean active, class_1937 world, class_2338 pos) {
		if (hasCustomStates) {
			return;
		}
		class_2350 facing = world.method_8320(pos).method_11654(FACING);
		class_2680 state = world.method_8320(pos).method_11657(ACTIVE, active).method_11657(FACING, facing);
		world.method_8652(pos, state, 3);
	}

	public boolean isActive(class_2680 state) {
		return state.method_11654(ACTIVE);
	}

	public boolean isAdvanced() {
		return false;
	}

	public abstract IMachineGuiHandler getGui();

	// BaseBlockEntityProvider
	@Override
	public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
		super.method_9567(worldIn, pos, state, placer, stack);
		setFacing(placer.method_5735().method_10153(), worldIn, pos);

		class_2586 blockEntity = worldIn.method_8321(pos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			((MachineBaseBlockEntity) blockEntity).onPlace(worldIn, pos, state, placer, stack);
		}
	}

	@Override
	public class_2586 method_10123(class_1922 worldIn) {
		return null;
	}

	// Block
	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING, ACTIVE);
	}

	@SuppressWarnings("deprecation")
	@Override
	public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			ItemHandlerUtils.dropContainedItems(worldIn, pos);
			super.method_9536(state, worldIn, pos, newState, isMoving);
		}
	}

	@Override
	public void method_9576(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 playerEntity) {
		class_2586 blockEntity = world.method_8321(blockPos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			((MachineBaseBlockEntity) blockEntity).onBreak(world, playerEntity, blockPos, blockState);
		}
		super.method_9576(world, blockPos, blockState, playerEntity);
	}

	@SuppressWarnings("deprecation")
	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@SuppressWarnings("deprecation")
	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return class_1703.method_7618(method_17680(state, world, pos));
	}

	/*
	 *  Right-click should open GUI for all non-wrench items
	 *  Shift-Right-click should apply special action, like fill\drain bucket, install behavior, etc.
	 */
	@SuppressWarnings("deprecation")
	@Override
	public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hitResult) {

		class_1799 stack = playerIn.method_5998(hand);
		class_2586 blockEntity = worldIn.method_8321(pos);

		// We extended BlockTileBase. Thus we should always have blockEntity entity. I hope.
		if (blockEntity == null) {
			return class_1269.field_5811;
		}

		if (blockEntity instanceof MachineBaseBlockEntity) {
			Tank tank = ((MachineBaseBlockEntity) blockEntity).getTank();
			if (tank != null && FluidUtil.interactWithFluidHandler(playerIn, hand, tank)) {
				return class_1269.field_5812;
			}
		}

		if (!stack.method_7960()) {
			if (ToolManager.INSTANCE.canHandleTool(stack)) {
				if (WrenchUtils.handleWrench(stack, worldIn, pos, playerIn, hitResult.method_17780())) {
					return class_1269.field_5812;
				}
			} else if (stack.method_7909() instanceof IUpgrade && blockEntity instanceof IUpgradeable) {
				IUpgradeable upgradeableEntity = (IUpgradeable) blockEntity;
				if (upgradeableEntity.canBeUpgraded()) {
					if (InventoryUtils.insertItemStacked(upgradeableEntity.getUpgradeInvetory(), stack,
							true).method_7947() > 0) {
						stack = InventoryUtils.insertItemStacked(upgradeableEntity.getUpgradeInvetory(), stack, false);
						playerIn.method_6122(class_1268.field_5808, stack);
						return class_1269.field_5812;
					}
				}
			}
		}

		if (getGui() != null && !playerIn.method_5715()) {
			getGui().open(playerIn, pos, worldIn);
			return class_1269.field_5812;
		}

		return super.method_9534(state, worldIn, pos, playerIn, hand, hitResult);
	}

	@SuppressWarnings("deprecation")
	@Override
	public class_2680 method_9598(class_2680 state, class_2470 rotation) {
		return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
	}

	// InventoryProvider
	@Override
	public class_1278 method_17680(class_2680 blockState, class_1936 world, class_2338 blockPos) {
		class_2586 blockEntity = world.method_8321(blockPos);
		if (blockEntity instanceof MachineBaseBlockEntity) {
			return (MachineBaseBlockEntity) blockEntity;
		}
		return null;
	}
}
