/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.client.texture;

import org.apache.commons.io.IOUtils;

import org.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4536;

/**
 * Created by modmuss50 on 23/05/2016.
 */
public class InputStreamTexture extends class_1044 {
	protected final InputStream textureLocation;
	class_1011 image;
	String name;

	public InputStreamTexture(InputStream textureResourceLocation, String name) {
		this.textureLocation = textureResourceLocation;
		this.name = name;
	}

	@Override
	public void method_4625(class_3300 resourceManager) throws IOException {
		this.method_4528();
		if (image == null) {
			class_3298 iresource = null;
			try {
				iresource = new class_3298() {

					@Override
					public class_2960 method_14483() {
						return new class_2960("reborncore:loaded/" + name);
					}

					@Override
					public InputStream method_14482() {
						return textureLocation;
					}

					@Nullable
					@Override
					public <T> T method_14481(class_3270<T> iMetadataSectionSerializer) {
						return null;
					}

					@Override
					public String method_14480() {
						return "reborncore";
					}

					@Override
					public void close() {

					}
				};
				image = class_1011.method_4309(iresource.method_14482());
			} finally {
				IOUtils.closeQuietly(iresource);
			}
		}
		this.method_23207();
		class_4536.method_24959(this.method_4624(), 0, image.method_4307(), image.method_4323());
		image.method_4301(0, 0, 0, true);
	}
}
