/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.util;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;

/**
 * Created by Mark on 13/03/2016.
 */
public class WorldUtils {

	public static void updateBlock(class_1937 world, class_2338 pos) {
		class_2680 state = world.method_8320(pos);
		world.method_8413(pos, state, state, 3);
	}

	public static boolean chunkExists(class_1937 world, int x, int z) {
		return world.method_22340(new class_2338(x << 4, 64, z << 4));
	}

	public static void dropItem(class_1799 itemStack, class_1937 world, class_2338 pos) {
		Random rand = new Random();

		float dX = rand.nextFloat() * 0.8F + 0.1F;
		float dY = rand.nextFloat() * 0.8F + 0.1F;
		float dZ = rand.nextFloat() * 0.8F + 0.1F;

		class_1542 entityItem = new class_1542(world, pos.method_10263() + dX, pos.method_10264() + dY, pos.method_10260() + dZ,
				itemStack.method_7972());

		if (itemStack.method_7985()) {
			entityItem.method_6983().method_7980(itemStack.method_7969().method_10553());
		}

		float factor = 0.05F;
		entityItem.method_18799(new class_243(rand.nextGaussian() * factor, rand.nextGaussian() * factor + 0.2F, rand.nextGaussian() * factor));
		if (!world.field_9236) {
			world.method_8649(entityItem);
		}
	}

	public static void dropItem(class_1792 item, class_1937 world, class_2338 pos) {
		dropItem(new class_1799(item), world, pos);
	}

	public static void dropItems(List<class_1799> itemStackList, class_1937 world, class_2338 pos) {
		for (final class_1799 itemStack : itemStackList) {
			WorldUtils.dropItem(itemStack, world, pos);
			itemStack.method_7939(0);
		}
	}
}
