/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.common.fluid;

import net.minecraft.class_2960;

public class FluidSettings {

	private class_2960 flowingTexture = new class_2960("reborncore:nope");
	private class_2960 stillTexture = new class_2960("reborncore:nope");

	public FluidSettings setFlowingTexture(class_2960 flowingTexture) {
		this.flowingTexture = flowingTexture;
		return this;
	}

	public FluidSettings setStillTexture(class_2960 stillTexture) {
		this.stillTexture = stillTexture;
		return this;
	}

	public class_2960 getFlowingTexture() {
		return flowingTexture;
	}

	public class_2960 getStillTexture() {
		return stillTexture;
	}

	private FluidSettings() {
	}

	public static FluidSettings create() {
		return new FluidSettings();
	}

}
