/*
 * This file is part of RebornCore, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2021 TeamReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.api.items;

import net.minecraft.block.*;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3954;
import reborncore.common.util.ItemUtils;

import org.jetbrains.annotations.Nullable;

public class InventoryUtils {

	public static class_1799 insertItemStacked(class_1263 inventory, class_1799 input, boolean simulate) {
		class_1799 stack = input.method_7972();
		for (int i = 0; i < inventory.method_5439(); i++) {
			class_1799 targetStack = inventory.method_5438(i);

			//Nice and simple, insert the item into a blank slot
			if (targetStack.method_7960()) {
				if (!simulate) {
					inventory.method_5447(i, stack);
				}
				return class_1799.field_8037;
			} else if (ItemUtils.isItemEqual(stack, targetStack, true, false)) {
				int freeStackSpace = targetStack.method_7914() - targetStack.method_7947();
				if (freeStackSpace > 0) {
					int transferAmount = Math.min(freeStackSpace, input.method_7947());
					if (!simulate) {
						targetStack.method_7933(transferAmount);
					}
					stack.method_7934(transferAmount);
				}
			}
		}
		return stack;
	}

	public static class_1799 insertItem(class_1799 input, class_1263 inventory, class_2350 direction) {
		class_1799 stack = input.method_7972();

		if (inventory instanceof class_1278) {
			class_1278 sidedInventory = (class_1278) inventory;
			for (int slot : sidedInventory.method_5494(direction)) {
				if (sidedInventory.method_5492(slot, stack, direction)) {
					stack = insertIntoInv(sidedInventory, slot, stack);
					if (stack.method_7960()) {
						break;
					}
				}
			}
			return stack;
		} else {
			for (int i = 0; i < inventory.method_5439() & !stack.method_7960(); i++) {
				if (inventory.method_5437(i, stack)) {
					stack = insertIntoInv(inventory, i, stack);
				}
			}
		}
		return stack;
	}

	@Nullable
	public static class_1263 getInventoryAt(class_1937 world, class_2338 blockPos) {
		class_1263 inventory = null;
		class_2680 blockState = world.method_8320(blockPos);
		class_2248 block = blockState.method_26204();
		if (block instanceof class_3954) {
			inventory = ((class_3954) block).method_17680(blockState, world, blockPos);
		} else if (block instanceof class_2343) {
			class_2586 blockEntity = world.method_8321(blockPos);
			if (blockEntity instanceof class_1263) {
				inventory = (class_1263) blockEntity;
				if (inventory instanceof class_2595 && block instanceof class_2281) {
					inventory = class_2281.method_17458((class_2281) block, blockState, world, blockPos, true);
				}
			}
		}
		return inventory;
	}

	private static class_1799 insertIntoInv(class_1263 inventory, int slot, class_1799 input) {
		class_1799 targetStack = inventory.method_5438(slot);
		class_1799 stack = input.method_7972();

		//Nice and simple, insert the item into a blank slot
		if (targetStack.method_7960()) {
			inventory.method_5447(slot, stack);
			return class_1799.field_8037;
		} else if (ItemUtils.isItemEqual(stack, targetStack, true, false)) {
			int freeStackSpace = targetStack.method_7914() - targetStack.method_7947();
			if (freeStackSpace > 0) {
				int transferAmount = Math.min(freeStackSpace, stack.method_7947());
				targetStack.method_7933(transferAmount);
				stack.method_7934(transferAmount);
			}
		}

		return stack;
	}
}
