/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiObseravable<A, B> {
    @Nullable
    private A a;
    @Nullable
    private B b;
    private final List<BiConsumer<A, B>> listeners = new LinkedList<BiConsumer<A, B>>();

    public void pushA(A a) {
        this.a = a;
        this.fireListeners();
    }

    public void pushB(B b) {
        this.b = b;
        this.fireListeners();
    }

    @NotNull
    public A getA() {
        Objects.requireNonNull(this.a);
        return this.a;
    }

    @NotNull
    public B getB() {
        Objects.requireNonNull(this.b);
        return this.b;
    }

    private void fireListeners() {
        if (this.a == null || this.b == null) {
            return;
        }
        for (BiConsumer<A, B> listener : this.listeners) {
            listener.accept(this.a, this.b);
        }
    }

    public void listen(@NotNull @NotNull BiConsumer<@NotNull A, @NotNull B> consumer) {
        this.listeners.add(consumer);
    }
}

