/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.fluid.container;

import net.minecraft.class_1799;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;

public interface GenericFluidContainer<T> {
    @Nullable
    public static GenericFluidContainer<class_1799> fromStack(@NotNull class_1799 itemStack) {
        if (itemStack.method_7909() instanceof GenericFluidContainer) {
            return (GenericFluidContainer)itemStack.method_7909();
        }
        return null;
    }

    public void setFluid(T var1, @NotNull FluidInstance var2);

    @NotNull
    public FluidInstance getFluidInstance(T var1);

    public FluidValue getCapacity(T var1);

    default public boolean canHold(T type, class_3611 fluid) {
        return true;
    }

    default public FluidValue getCurrentFluidAmount(T type) {
        return this.getFluidInstance(type).getAmount();
    }

    default public boolean canInsertFluid(T type, @NotNull class_3611 fluid, FluidValue amount) {
        if (!this.canHold(type, fluid)) {
            return false;
        }
        FluidInstance currentFluid = this.getFluidInstance(type);
        return currentFluid.isEmpty() || currentFluid.getFluid() == fluid && currentFluid.getAmount().add(amount).lessThan(this.getCapacity(type));
    }

    default public boolean canExtractFluid(T type, @NotNull class_3611 fluid, FluidValue amount) {
        return this.getFluidInstance(type).getFluid() == fluid && amount.lessThanOrEqual(this.getFluidInstance(type).getAmount());
    }

    default public void insertFluid(T type, @NotNull class_3611 fluid, FluidValue amount) {
        if (this.canInsertFluid(type, fluid, amount)) {
            this.setFluid(type, this.getFluidInstance(type).addAmount(amount));
        }
    }

    default public void extractFluid(T type, @NotNull class_3611 fluid, FluidValue amount) {
        if (this.canExtractFluid(type, fluid, amount)) {
            this.setFluid(type, this.getFluidInstance(type).subtractAmount(amount));
        }
    }
}

