/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.ingredient.RebornIngredient;

public class RecipeManager {
    private static final Map<class_2960, RebornRecipeType<?>> recipeTypes = new HashMap();

    public static <R extends RebornRecipe> RebornRecipeType<R> newRecipeType(BiFunction<RebornRecipeType<R>, class_2960, R> recipeFunction, class_2960 name) {
        if (recipeTypes.containsKey(name)) {
            throw new RuntimeException("RebornRecipe type with this name already registered");
        }
        RebornRecipeType<R> type = new RebornRecipeType<R>(recipeFunction, name);
        recipeTypes.put(name, type);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)name, type);
        return type;
    }

    public static RebornRecipeType<?> getRecipeType(class_2960 name) {
        if (!recipeTypes.containsKey(name)) {
            throw new RuntimeException("RebornRecipe type " + name + " not found");
        }
        return recipeTypes.get(name);
    }

    public static List<RebornRecipeType> getRecipeTypes(String namespace) {
        return recipeTypes.values().stream().filter(rebornRecipeType -> rebornRecipeType.getName().method_12836().equals(namespace)).collect(Collectors.toList());
    }

    public static void validateRecipes(class_1937 world) {
        System.out.println("Validating recipes");
        world.method_8433().method_8127().forEach(identifier -> {
            try {
                class_1860 recipe = (class_1860)world.method_8433().method_8130(identifier).get();
                class_1865 recipeSerializer = recipe.method_8119();
                class_2540 buf = new class_2540(Unpooled.buffer());
                recipeSerializer.method_8124(buf, recipe);
                class_1860 class_18602 = recipeSerializer.method_8122(identifier, buf);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read " + identifier, e);
            }
        });
        System.out.println("Done");
    }

    private static <R extends RebornRecipe> void validate(RebornRecipeType<R> rebornRecipeType, class_1937 world) {
        List<R> recipes = rebornRecipeType.getRecipes(world);
        for (RebornRecipe recipe1 : recipes) {
            for (RebornRecipe recipe2 : recipes) {
                if (recipe1 == recipe2) continue;
                Validate.isTrue((recipe1.getRebornIngredients().size() > 0 ? 1 : 0) != 0, (String)(recipe1.method_8114() + " has no inputs"), (Object[])new Object[0]);
                Validate.isTrue((recipe2.getRebornIngredients().size() > 0 ? 1 : 0) != 0, (String)(recipe2.method_8114() + " has no inputs"), (Object[])new Object[0]);
                Validate.isTrue((recipe1.getOutputs().size() > 0 ? 1 : 0) != 0, (String)(recipe1.method_8114() + " has no outputs"), (Object[])new Object[0]);
                Validate.isTrue((recipe2.getOutputs().size() > 0 ? 1 : 0) != 0, (String)(recipe2.method_8114() + " has no outputs"), (Object[])new Object[0]);
                boolean hasAll = true;
                for (RebornIngredient recipe1Input : recipe1.getRebornIngredients()) {
                    boolean matches = false;
                    for (class_1799 testStack : recipe1Input.getPreviewStacks()) {
                        for (RebornIngredient recipe2Input : recipe2.getRebornIngredients()) {
                            if (!recipe2Input.test(testStack)) continue;
                            matches = true;
                        }
                    }
                    if (matches) continue;
                    hasAll = false;
                }
                if (!hasAll) continue;
                System.out.println(recipe1.method_8114() + " conflicts with " + recipe2.method_8114());
            }
        }
    }
}

