/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.cottonmc.libcd.api.CustomOutputRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.apache.commons.lang3.Validate;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.crafting.ingredient.DummyIngredient;
import reborncore.common.crafting.ingredient.IngredientManager;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.util.DefaultedListCollector;
import reborncore.common.util.serialization.SerializationUtil;

public class RebornRecipe
implements class_1860<class_1263>,
CustomOutputRecipe {
    private final RebornRecipeType<?> type;
    private final class_2960 name;
    private class_2371<RebornIngredient> ingredients = class_2371.method_10211();
    private class_2371<class_1799> outputs = class_2371.method_10211();
    protected int power;
    protected int time;
    protected boolean dummy = false;

    public RebornRecipe(RebornRecipeType<?> type, class_2960 name) {
        this.type = type;
        this.name = name;
    }

    public RebornRecipe(RebornRecipeType<?> type, class_2960 name, class_2371<RebornIngredient> ingredients, class_2371<class_1799> outputs, int power, int time) {
        this(type, name);
        this.ingredients = ingredients;
        this.outputs = outputs;
        this.power = power;
        this.time = time;
    }

    public void deserialize(JsonObject jsonObject) {
        if (jsonObject.has("dummy")) {
            this.makeDummy();
            return;
        }
        Validate.isTrue((boolean)this.ingredients.isEmpty());
        this.power = class_3518.method_15260((JsonObject)jsonObject, (String)"power");
        this.time = class_3518.method_15260((JsonObject)jsonObject, (String)"time");
        this.ingredients = (class_2371)SerializationUtil.stream(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients")).map(IngredientManager::deserialize).collect(DefaultedListCollector.toList());
        JsonArray resultsJson = class_3518.method_15261((JsonObject)jsonObject, (String)"results");
        this.outputs = RecipeUtils.deserializeItems((JsonElement)resultsJson);
    }

    public void serialize(JsonObject jsonObject) {
        if (this.isDummy()) {
            jsonObject.addProperty("dummy", Boolean.valueOf(true));
            return;
        }
        jsonObject.addProperty("power", (Number)this.power);
        jsonObject.addProperty("time", (Number)this.time);
        JsonArray ingredientsArray = new JsonArray();
        this.getRebornIngredients().stream().map(RebornIngredient::witeToJson).forEach(arg_0 -> ((JsonArray)ingredientsArray).add(arg_0));
        jsonObject.add("ingredients", (JsonElement)ingredientsArray);
        JsonArray resultsArray = new JsonArray();
        for (class_1799 stack : this.outputs) {
            JsonObject stackObject = new JsonObject();
            stackObject.addProperty("item", class_2378.field_11142.method_10221((Object)stack.method_7909()).toString());
            if (stack.method_7947() > 1) {
                stackObject.addProperty("count", (Number)stack.method_7947());
            }
            if (stack.method_7985()) {
                stackObject.add("nbt", (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)stack.method_7969()));
            }
            resultsArray.add((JsonElement)stackObject);
        }
        jsonObject.add("results", (JsonElement)resultsArray);
    }

    public void serialize(class_2540 byteBuf) {
    }

    public void deserialize(class_2540 byteBuf) {
    }

    public class_2960 method_8114() {
        return this.name;
    }

    public class_1865<?> method_8119() {
        return this.type;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public RebornRecipeType<?> getRebornRecipeType() {
        return this.type;
    }

    @Deprecated
    public class_2371<class_1856> method_8117() {
        return (class_2371)this.ingredients.stream().map(RebornIngredient::getPreview).collect(DefaultedListCollector.toList());
    }

    public class_2371<RebornIngredient> getRebornIngredients() {
        return this.ingredients;
    }

    public List<class_1799> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public int getPower() {
        return this.power;
    }

    public int getTime() {
        return this.time;
    }

    public boolean canCraft(class_2586 blockEntity) {
        if (this.isDummy()) {
            return false;
        }
        if (blockEntity instanceof IRecipeCrafterProvider) {
            return ((IRecipeCrafterProvider)blockEntity).canCraft(this);
        }
        return true;
    }

    public boolean onCraft(class_2586 blockEntity) {
        return true;
    }

    @Deprecated
    public boolean method_8115(class_1263 inv, class_1937 worldIn) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public class_1799 method_8116(class_1263 inv) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean method_8113(int width, int height) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public class_1799 method_8110() {
        if (this.isDummy() || this.outputs.isEmpty()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.outputs.get(0);
    }

    public class_2371<class_1799> method_8111(class_1263 p_179532_1_) {
        throw new UnsupportedOperationException();
    }

    public boolean method_8118() {
        return true;
    }

    private boolean isDummy() {
        return this.dummy;
    }

    void makeDummy() {
        this.ingredients.add((Object)new DummyIngredient());
        this.dummy = true;
    }

    @Override
    public Collection<class_1792> getOutputItems() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (class_1799 stack : this.outputs) {
            items.add(stack.method_7909());
        }
        return items;
    }
}

