/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.mixin.common;

import com.google.gson.JsonObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import reborncore.common.crafting.ConditionManager;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Mixin(class_1863.class)
public class MixinRecipeManager {

	@Inject(method = "apply", at = @At("HEAD"))
	private void deserialize(Map<class_2960, JsonObject> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo info) {
		Iterator<Map.Entry<class_2960, JsonObject>> iterator = map.entrySet().iterator();
		while (iterator.hasNext()) {
			Map.Entry<class_2960, JsonObject> entry = iterator.next();
			class_2960 id = entry.getKey();
			JsonObject json = entry.getValue();

			// TODO dont hard code this as its awful
			if (id.method_12836().equals("reborncore") || id.method_12836().equals("techreborn")) {
				if (!ConditionManager.shouldLoadRecipe(json)) {
					iterator.remove();
				}
			}
		}
	}
}
