/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package reborncore.mixin.common;

import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3611;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import reborncore.common.fluid.RebornFluidManager;
import reborncore.common.fluid.container.ItemFluidInfo;

@Mixin(class_1755.class)
public class MixinBucketItem implements ItemFluidInfo {

	@Shadow
	@Final
	private class_3611 fluid;

	@Override
	public class_1799 getEmpty() {
		return new class_1799(class_1802.field_8550);
	}

	@Override
	public class_1799 getFull(class_3611 fluid) {
		class_1755 item = RebornFluidManager.getBucketMap().get(fluid);
		return new class_1799(item);
	}

	@Override
	public class_3611 getFluid(class_1799 itemStack) {
		return fluid;
	}
}
